/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultNormalizedFileSnapshot;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.NormalizedFileSnapshot;
import org.gradle.internal.fingerprint.impl.IgnoredPathFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;

public class SnapshotMapSerializer
extends AbstractSerializer<Map<String, NormalizedFileSnapshot>> {
    private static final byte DEFAULT_NORMALIZATION = 1;
    private static final byte IGNORED_PATH_NORMALIZATION = 2;
    private static final byte DIR_SNAPSHOT = 1;
    private static final byte MISSING_FILE_SNAPSHOT = 2;
    private static final byte REGULAR_FILE_SNAPSHOT = 3;
    private final HashCodeSerializer hashCodeSerializer = new HashCodeSerializer();
    private final StringInterner stringInterner;

    public SnapshotMapSerializer(StringInterner stringInterner) {
        this.stringInterner = stringInterner;
    }

    public Map<String, NormalizedFileSnapshot> read(Decoder decoder) throws IOException {
        int snapshotsCount = decoder.readSmallInt();
        LinkedHashMap<String, NormalizedFileSnapshot> snapshots = new LinkedHashMap<String, NormalizedFileSnapshot>(snapshotsCount);
        for (int i = 0; i < snapshotsCount; ++i) {
            String absolutePath = this.stringInterner.intern(decoder.readString());
            NormalizedFileSnapshot snapshot = this.readSnapshot(decoder);
            snapshots.put(absolutePath, snapshot);
        }
        return snapshots;
    }

    private NormalizedFileSnapshot readSnapshot(Decoder decoder) throws IOException {
        FileType fileType = this.readFileType(decoder);
        HashCode contentHash = this.readContentHash(fileType, decoder);
        byte normalizedSnapshotKind = decoder.readByte();
        switch (normalizedSnapshotKind) {
            case 1: {
                String normalizedPath = decoder.readString();
                return new DefaultNormalizedFileSnapshot(this.stringInterner.intern(normalizedPath), fileType, contentHash);
            }
            case 2: {
                return IgnoredPathFingerprint.create(fileType, contentHash);
            }
        }
        throw new RuntimeException("Unable to read serialized file snapshot. Unrecognized value found in the data stream.");
    }

    private HashCode readContentHash(FileType fileType, Decoder decoder) throws IOException {
        switch (fileType) {
            case Directory: {
                return NormalizedFileSnapshot.DIR_SIGNATURE;
            }
            case Missing: {
                return NormalizedFileSnapshot.MISSING_FILE_SIGNATURE;
            }
            case RegularFile: {
                return this.hashCodeSerializer.read(decoder);
            }
        }
        throw new RuntimeException("Unable to read serialized file snapshot. Unrecognized value found in the data stream.");
    }

    private FileType readFileType(Decoder decoder) throws IOException {
        byte fileSnapshotKind = decoder.readByte();
        switch (fileSnapshotKind) {
            case 1: {
                return FileType.Directory;
            }
            case 2: {
                return FileType.Missing;
            }
            case 3: {
                return FileType.RegularFile;
            }
        }
        throw new RuntimeException("Unable to read serialized file snapshot. Unrecognized value found in the data stream.");
    }

    public void write(Encoder encoder, Map<String, NormalizedFileSnapshot> value) throws Exception {
        encoder.writeSmallInt(value.size());
        for (String key : value.keySet()) {
            encoder.writeString((CharSequence)key);
            NormalizedFileSnapshot snapshot = value.get(key);
            this.writeSnapshot(encoder, snapshot);
        }
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        SnapshotMapSerializer rhs = (SnapshotMapSerializer)((Object)obj);
        return Objects.equal((Object)this.hashCodeSerializer, (Object)rhs.hashCodeSerializer);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.hashCodeSerializer});
    }

    private void writeSnapshot(Encoder encoder, NormalizedFileSnapshot value) throws IOException {
        switch (value.getType()) {
            case Directory: {
                encoder.writeByte((byte)1);
                break;
            }
            case Missing: {
                encoder.writeByte((byte)2);
                break;
            }
            case RegularFile: {
                encoder.writeByte((byte)3);
                this.hashCodeSerializer.write(encoder, value.getNormalizedContentHash());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (value instanceof DefaultNormalizedFileSnapshot) {
            encoder.writeByte((byte)1);
            encoder.writeString((CharSequence)value.getNormalizedPath());
        } else if (value instanceof IgnoredPathFingerprint) {
            encoder.writeByte((byte)2);
        } else {
            throw new AssertionError();
        }
    }
}

