/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.CompositeStoppable;

public class ExecOutputHandleRunner
implements Runnable {
    private static final Logger LOGGER = Logging.getLogger(ExecOutputHandleRunner.class);
    private final String displayName;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final int bufferSize;
    private final CountDownLatch completed;

    public ExecOutputHandleRunner(String displayName, InputStream inputStream, OutputStream outputStream, CountDownLatch completed) {
        this(displayName, inputStream, outputStream, 2048, completed);
    }

    ExecOutputHandleRunner(String displayName, InputStream inputStream, OutputStream outputStream, int bufferSize, CountDownLatch completed) {
        this.displayName = displayName;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.bufferSize = bufferSize;
        this.completed = completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.forwardContent();
        }
        finally {
            this.completed.countDown();
        }
    }

    private void forwardContent() {
        byte[] buffer = new byte[this.bufferSize];
        try {
            int nread;
            while ((nread = this.inputStream.read(buffer)) >= 0) {
                this.outputStream.write(buffer, 0, nread);
                this.outputStream.flush();
            }
            CompositeStoppable.stoppable((Object[])new Object[]{this.inputStream, this.outputStream}).stop();
        }
        catch (Throwable t) {
            if (this.wasInterrupted(t)) {
                return;
            }
            LOGGER.error(String.format("Could not %s.", this.displayName), t);
        }
    }

    private boolean wasInterrupted(Throwable t) {
        return t instanceof IOException && "Interrupted system call".equals(t.getMessage());
    }

    public void closeInput() throws IOException {
        this.inputStream.close();
    }

    public String toString() {
        return this.displayName;
    }
}

