
local base_topic = "/help chat"
local base_button = "Chat"

local function topic_chat()
	ib:SetHeader("st_001", "")
	ib:SetTitle("Chat")

	ib:SetMsg("\n\nYou can use a variety of chat commands to communicate with other players. The most basic form of chat is local chat. You can communicate with nearby players by simply pressing ~Enter~ to open up the ~console~, typing a message, and pressing ~Enter~.")
	ib:AddMsg("\n\nYou can also use the following commands to chat with a broader audience.")

	ib:AddLink("Global chat using /shout", "/help /shout")
	ib:AddLink("Individual chat using /tell", "/help /tell")
	ib:AddLink("Emotes", "/help emotes")
	ib:AddLink("Channel communication", "/help /channel")
	ib:AddLink("Party communication", "/help /gsay")
	ib:SetLHSButton("Back", "/help main")
end

local function topic_shout()
	ib:SetHeader("st_001", "")
	ib:SetTitle("Command: /shout")

	ib:SetMsg("\n\nThe ~/shout~ command allows you to communicate with all players currently in the game. It can be used for general chat, game help, trading, and more.")
	ib:AddMsg("\n\n~/shout~ posts a message in the ~General~ chat channel. For more information on channels, click the link below.")
	ib:AddMsg("\n\n`Usage`")
	ib:AddMsg("\n\n~/shout (message)~")

	ib:AddLink("More about channels", "/help /channel")
	ib:SetLHSButton(base_button, base_topic)
end

local function topic_tell()
	ib:SetHeader("st_001", "")
	ib:SetTitle("Command: /tell")

	ib:SetMsg("\n\nThe ~/tell~ command allows you to communicate privately with an individual player. This only works if the player is currently online. If they are offline or online in privacy mode, you will be informed that there is no such player.")
	ib:AddMsg("\n\nYou can also use the ~/reply~ command to send a message to the last player who sent you a private message.")
	ib:AddMsg("\n\n`Usage`")
	ib:AddMsg("\n\n~/tell (player) (message)~")
	ib:AddMsg("\n~/reply (message)~")

	ib:SetLHSButton(base_button, base_topic)
end

local function topic_emotes()
	ib:SetHeader("st_001", "")
	ib:SetTitle("Emotes")

	ib:SetMsg("Emotes are a way to express yourself through actions! Local emotes will be broadcast in the right-hand text window to all players in your area. Channel emotes will appear to all players in a particular channel in their chat window.")
	ib:AddMsg("\n\n`Custom usage`")
	ib:AddMsg("\n\n~/me (custom emote message)~")
	ib:AddMsg("\n\n`Standard emotes`")
	ib:AddMsg("\n\nUsage: ~/(emote)~")
	ib:AddMsg("~\n\n" .. 
"~nod~, ~bounce~, ~laugh~, ~puke~, ~sigh~, ~cry~, ~grin~, ~blush~, ~cough~," ..
" ~gasp~, ~hiccup~, ~shiver~, ~smirk~, ~snicker~, ~spit~, ~twiddle~," ..
" ~wink~, ~bleed~, ~dance~, ~smile~, ~giggle~, ~growl~, ~sulk~, ~poke~," ..
" ~bow~, ~burp~, ~flip~, ~glare~, ~lick~, ~shrug~, ~snap~, ~sniff~, ~strut~," ..
" ~wave~, ~yawn~, ~cringe~, ~kiss~, ~cackle~, ~shake~, ~scream~, ~hug~," ..
" ~accuse~, ~clap~, ~chuckle~, ~frown~, ~groan~, ~pout~, ~slap~, ~sneeze~," ..
" ~snore~, ~thank~, ~whistle~, ~beg~, ~think~")

	-- IDK why yet but the two ~~ are needed to prevent this line from being green.
	ib:AddMsg("\n\n~~For info about channel emotes, visit:")

	ib:AddLink("Command: /channel", "/help /channel")
	ib:SetLHSButton(base_button, base_topic)
end

local function topic_channel()
    ib:SetHeader("st_001", player)
    ib:SetTitle("Command: /channel")

    ib:SetMsg("\n\nThe ~/channel~ command is used to communicate with other players over various chat channels. New players are automatically added to the ~General~, ~Help~, and ~Quest~ channels.")
    ib:AddMsg("\n\nTo chat in a channel, type ~/channel (channel) (message)~ and pressing enter. You can also use the channel's ~shortcut~ instead of the full name of the channel. The ~General~ channel can also be used via the ~/shout~ command.")
    ib:AddMsg("\n\nYou can view a list of channels you are in, as well as the number of players in that channel and the channel's ~shortcut~ by typing ~/channel ?~.\n\n")
    ib:AddMsg("`Other uses`")
    ib:AddMsg("\n\n~/channel (channel)$~: Automatically sends a description of the player's current ~M~arked item to the specified ~(channel)~.")
    ib:AddMsg("\n\n~/channel (channel)+~: Joins the specified ~(channel)~ if the player meets channel requirements.")
    ib:AddMsg("\n\n~/channel (channel)-~: Leaves the specified ~(channel)~.")
    ib:AddMsg("\n\n`Related info`")
    ib:AddLink("Command: /shout", "/help /shout")
    ib:SetLHSButton(base_button, base_topic)
end

tl:AddTopics("/help /channel", topic_channel)
tl:AddTopics("/help emotes", topic_emotes)
tl:AddTopics("/help /tell", topic_tell)
tl:AddTopics("/help /shout", topic_shout)
tl:AddTopics("/help chat", topic_chat)