/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EntitySelector;
import megamek.common.IGame;
import megamek.common.Minefield;
import megamek.common.Report;
import megamek.common.Team;
import megamek.common.TurnOrdered;
import megamek.common.VTOL;
import megamek.common.event.GamePlayerChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Player
extends TurnOrdered
implements Serializable {
    private static final long serialVersionUID = 6828849559007455760L;
    public static final int PLAYER_NONE = -1;
    public static final int TEAM_NONE = 0;
    public static final String[] colorNames = new String[]{"Blue", "Yellow", "Red", "Green", "White", "Cyan", "Pink", "Orange", "Gray", "Brown", "Purple"};
    public static final String[] teamNames = new String[]{"No Team", "Team 1", "Team 2", "Team 3", "Team 4", "Team 5"};
    public static final int MAX_TEAMS = teamNames.length;
    private transient IGame game;
    private String name = "unnamed";
    private int id;
    private int team = 0;
    private boolean done = false;
    private boolean ghost = false;
    private boolean observer = false;
    private boolean see_entire_board = false;
    private int colorIndex = 0;
    private int startingPos = 0;
    private int num_mf_conv = 0;
    private int num_mf_cmd = 0;
    private int num_mf_vibra = 0;
    private int num_mf_active = 0;
    private int num_mf_inferno = 0;
    private Vector<Coords> artyAutoHitHexes = new Vector();
    private int initialBV;
    private int constantInitBonus = 0;
    public static final String NO_CAMO = "-- No Camo --";
    public static final String ROOT_CAMO = "-- General --";
    private String camoCategory = "-- No Camo --";
    private String camoFileName = null;
    private Vector<Minefield> visibleMinefields = new Vector();
    private boolean admitsDefeat = false;
    private Vector<Report> turnReports = new Vector();

    public Vector<Minefield> getMinefields() {
        return this.visibleMinefields;
    }

    public void addMinefield(Minefield minefield) {
        this.visibleMinefields.addElement(minefield);
    }

    public void addMinefields(Vector<Minefield> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.visibleMinefields.addElement(vector.elementAt(i));
        }
    }

    public void removeMinefield(Minefield minefield) {
        this.visibleMinefields.removeElement(minefield);
    }

    public void removeMinefields() {
        this.visibleMinefields.removeAllElements();
    }

    public void removeArtyAutoHitHexes() {
        this.artyAutoHitHexes.removeAllElements();
    }

    public boolean containsMinefield(Minefield minefield) {
        return this.visibleMinefields.contains(minefield);
    }

    public boolean hasMinefields() {
        return this.num_mf_cmd > 0 || this.num_mf_conv > 0 || this.num_mf_vibra > 0 || this.num_mf_active > 0 || this.num_mf_inferno > 0;
    }

    public void setNbrMFConventional(int n) {
        this.num_mf_conv = n;
    }

    public void setNbrMFCommand(int n) {
        this.num_mf_cmd = n;
    }

    public void setNbrMFVibra(int n) {
        this.num_mf_vibra = n;
    }

    public void setNbrMFActive(int n) {
        this.num_mf_active = n;
    }

    public void setNbrMFInferno(int n) {
        this.num_mf_inferno = n;
    }

    public int getNbrMFConventional() {
        return this.num_mf_conv;
    }

    public int getNbrMFCommand() {
        return this.num_mf_cmd;
    }

    public int getNbrMFVibra() {
        return this.num_mf_vibra;
    }

    public int getNbrMFActive() {
        return this.num_mf_active;
    }

    public int getNbrMFInferno() {
        return this.num_mf_inferno;
    }

    public void setCamoCategory(String string) {
        this.camoCategory = string;
    }

    public String getCamoCategory() {
        return this.camoCategory;
    }

    public void setCamoFileName(String string) {
        this.camoFileName = string;
    }

    public String getCamoFileName() {
        return this.camoFileName;
    }

    public Player(int n, String string) {
        this.name = string;
        this.id = n;
    }

    public void setGame(IGame iGame) {
        this.game = iGame;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getId() {
        return this.id;
    }

    public int getTeam() {
        return this.team;
    }

    public Vector<Report> getTurnReport() {
        return this.turnReports;
    }

    public void setTeam(int n) {
        this.team = n;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean bl) {
        this.done = bl;
        this.game.processGameEvent(new GamePlayerChangeEvent((Object)this, this));
    }

    public boolean isGhost() {
        return this.ghost;
    }

    public void setGhost(boolean bl) {
        this.ghost = bl;
    }

    public boolean isObserver() {
        if (this.game != null && this.game.getPhase() == IGame.Phase.PHASE_VICTORY) {
            return false;
        }
        return this.observer;
    }

    public void setSeeAll(boolean bl) {
        this.see_entire_board = bl;
    }

    public boolean getSeeAll() {
        return this.see_entire_board;
    }

    public boolean canSeeAll() {
        return this.observer && this.see_entire_board;
    }

    public void setObserver(boolean bl) {
        this.observer = bl;
        if (!bl) {
            this.setSeeAll(false);
        }
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public void setColorIndex(int n) {
        this.colorIndex = n;
    }

    public int getStartingPos() {
        return this.startingPos;
    }

    public void setStartingPos(int n) {
        this.startingPos = n;
    }

    public void adjustStartingPosForReinforcements() {
        if (this.startingPos > 10) {
            this.startingPos -= 10;
        }
        if (this.startingPos == 0 || this.startingPos == 10) {
            this.startingPos = 9;
        }
    }

    public boolean isEnemyOf(Player player) {
        return this.id != player.getId() && (this.team == 0 || this.team != player.getTeam());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Player player = (Player)object;
        return player.getId() == this.id;
    }

    public int hashCode() {
        return this.getId();
    }

    public void setAdmitsDefeat(boolean bl) {
        this.admitsDefeat = bl;
    }

    public boolean admitsDefeat() {
        return this.admitsDefeat;
    }

    public void setArtyAutoHitHexes(Vector<Coords> vector) {
        this.artyAutoHitHexes = vector;
    }

    public Vector<Coords> getArtyAutoHitHexes() {
        return this.artyAutoHitHexes;
    }

    public boolean hasTAG() {
        Enumeration<Entity> enumeration = this.game.getSelectedEntities(new EntitySelector(){
            private final int ownerId;
            {
                this.ownerId = Player.this.getId();
            }

            public boolean accept(Entity entity) {
                if (entity.getOwner() == null) {
                    return false;
                }
                return this.ownerId == entity.getOwner().getId();
            }
        });
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!entity.hasTAG()) continue;
            return true;
        }
        return false;
    }

    public int getBV() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (entity.getOwner() != this || entity.isDestroyed()) continue;
            n += entity.calculateBattleValue();
        }
        return (int)((float)n * this.getForceSizeBVMod());
    }

    public void setInitialBV() {
        this.initialBV = this.getBV();
    }

    public int getInitialBV() {
        return this.initialBV;
    }

    public float getForceSizeBVMod() {
        if (this.game.getOptions().booleanOption("no_force_size_mod")) {
            return 1.0f;
        }
        Enumeration<Entity> enumeration = this.game.getEntities();
        float f = 0.0f;
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!entity.getOwner().equals(this) || entity.isDestroyed()) continue;
            f += 1.0f;
        }
        float f2 = 0.0f;
        if (this.getTeam() == 0) {
            Enumeration<Player> enumeration2 = this.game.getPlayers();
            while (enumeration2.hasMoreElements()) {
                Player player = enumeration2.nextElement();
                if (player.equals(this)) continue;
                f2 += (float)this.game.getEntitiesOwnedBy(player);
            }
        } else {
            TurnOrdered turnOrdered;
            Enumeration<TurnOrdered> enumeration3;
            Team team = this.game.getTeamForPlayer(this);
            if (team != null) {
                enumeration3 = team.getPlayers();
                while (enumeration3.hasMoreElements()) {
                    turnOrdered = (Player)enumeration3.nextElement();
                    if (((Player)turnOrdered).equals(this)) continue;
                    f += (float)this.game.getEntitiesOwnedBy((Player)turnOrdered);
                }
            }
            enumeration3 = this.game.getTeams();
            while (enumeration3.hasMoreElements()) {
                turnOrdered = (Team)enumeration3.nextElement();
                if (((Team)turnOrdered).getId() == this.getTeam()) continue;
                Enumeration<Player> enumeration4 = ((Team)turnOrdered).getPlayers();
                while (enumeration4.hasMoreElements()) {
                    Player player = enumeration4.nextElement();
                    f2 += (float)this.game.getEntitiesOwnedBy(player);
                }
            }
        }
        if (f <= f2 || f2 == 0.0f || f == 0.0f) {
            return 1.0f;
        }
        return f2 / f + f / f2 - 1.0f;
    }

    public void setConstantInitBonus(int n) {
        this.constantInitBonus = n;
    }

    public int getConstantInitBonus() {
        return this.constantInitBonus;
    }

    public int getTurnInitBonus() {
        int n = 0;
        int n2 = 0;
        for (Entity entity : this.game.getEntitiesVector()) {
            if (!entity.getOwner().equals(this)) continue;
            if (this.game.getOptions().booleanOption("tacops_mobile_hqs") && n == 0 && entity.getHQIniBonus() > 0) {
                n = entity.getHQIniBonus();
            }
            if (!this.game.getOptions().booleanOption("manei_domini") || n2 != 0 || entity.getMDIniBonus() <= 0) continue;
            n2 = entity.getMDIniBonus();
        }
        return n + n2;
    }

    public int getCommandBonus() {
        int n = 0;
        if (this.game.getOptions().booleanOption("command_init")) {
            for (Entity entity : this.game.getEntitiesVector()) {
                if (!entity.getOwner().equals(this) || entity.isDestroyed() || !entity.isDeployed() || entity.isOffBoard() || !entity.getCrew().isActive() || entity.isCaptured() || entity.getCrew().getCommandBonus() <= n) continue;
                n = entity.getCrew().getCommandBonus();
            }
        }
        return n;
    }

    public Vector<Integer> getAirborneVTOL() {
        Vector<Integer> vector = new Vector<Integer>();
        for (Entity entity : this.game.getEntitiesVector()) {
            if (!entity.getOwner().equals(this) || entity.getElevation() <= 0 || !(entity instanceof VTOL) && entity.getMovementMode() != 15) continue;
            vector.add(entity.getId());
        }
        return vector;
    }
}

