/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Report;
import megamek.common.Tank;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.SRMHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRMTandemChargeHandler
extends SRMHandler {
    private static final long serialVersionUID = 6292692766500970690L;
    protected int generalDamageType = -7;

    public SRMTandemChargeHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.sSalvoType = " tandem charge missile(s) ";
    }

    @Override
    protected void handleEntityDamage(Entity entity, Vector<Report> vector, Building building, int n, int n2, int n3, int n4) {
        int n5;
        this.missed = false;
        HitData hitData = entity.rollHitLocation(this.toHit.getHitTable(), this.toHit.getSideTable(), this.waa.getAimedLocation(), this.waa.getAimingMode());
        hitData.setGeneralDamageType(this.generalDamageType);
        if (entity.removePartialCoverHits(hitData.getLocation(), this.toHit.getCover(), Compute.targetSideTable(this.ae, (Targetable)entity))) {
            this.r = new Report(3460);
            this.r.subject = this.subjectId;
            this.r.add(entity.getShortName());
            this.r.add(entity.getLocationAbbr(hitData));
            this.r.newlines = 0;
            this.r.indent(2);
            vector.addElement(this.r);
            boolean bl = false;
            this.missed = true;
            return;
        }
        if (!this.bSalvo) {
            this.r = new Report(3405);
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getTableDesc());
            this.r.add(entity.getLocationAbbr(hitData));
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        int n6 = n3 * Math.min(n2, n);
        if (n4 > 0) {
            n5 = Math.min(n4, n6);
            n6 -= n5;
            Report.addNewline(vector);
            Vector<Report> vector2 = this.server.damageBuilding(building, n5, entity.getPosition());
            for (Report report : vector2) {
                report.subject = this.subjectId;
            }
            vector.addAll(vector2);
        }
        if ((n6 = this.checkTerrain(n6, entity, vector)) == 0) {
            this.r = new Report(3415);
            this.r.subject = this.subjectId;
            this.r.indent(2);
            this.r.addDesc(entity);
            this.r.newlines = 0;
            vector.addElement(this.r);
            this.missed = true;
        } else {
            if (this.bGlancing) {
                hitData.makeGlancingBlow();
            }
            if (this.bDirect && (!(this.target instanceof Infantry) || this.target instanceof BattleArmor)) {
                hitData.makeDirectBlow(this.toHit.getMoS() / 3);
            }
            if (this.target instanceof BattleArmor && ((BattleArmor)this.target).getInternal(hitData.getLocation()) != -2) {
                n5 = Compute.d6(2);
                int n7 = hitData.getLocation();
                if (n5 >= 10) {
                    hitData = new HitData(n7, false, 1);
                }
            } else if (this.target instanceof Tank || this.target instanceof Mech) {
                if (this.bGlancing) {
                    hitData.setSpecCritmod(-4);
                } else if (this.bDirect) {
                    hitData.setSpecCritmod(this.toHit.getMoS() / 3 - 2);
                } else {
                    hitData.setSpecCritmod(-2);
                }
                if (entity.hasBARArmor()) {
                    hitData.setSpecCritmod(hitData.getSpecCritMod() + 2);
                }
            }
            vector.addAll(this.server.damageEntity(entity, hitData, n6, false, this.ae.getSwarmTargetId() == entity.getId() ? Server.DamageType.IGNORE_PASSENGER : Server.DamageType.NONE, false, false, this.throughFront, this.underWater));
        }
    }

    @Override
    protected int calcDamagePerHit() {
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            double d = Compute.directBlowInfantryDamage(this.wtype.getRackSize(), this.bDirect ? this.toHit.getMoS() / 3 : 0, 3, ((Infantry)this.target).isMechanized());
            if (this.bGlancing) {
                d /= 2.0;
            }
            return (int)Math.floor(d);
        }
        return 2;
    }
}

