/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.testing;

import java.io.File;
import java.util.LinkedList;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.tasks.testing.junit.result.AggregateTestResultsProvider;
import org.gradle.api.internal.tasks.testing.junit.result.BinaryResultBackedTestResultsProvider;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.internal.tasks.testing.report.HtmlTestReport;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.model.ReplacedBy;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.instrumentation.api.annotations.ReplacedAccessor;
import org.gradle.internal.instrumentation.api.annotations.ReplacedDeprecation;
import org.gradle.internal.instrumentation.api.annotations.ReplacesEagerProperty;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not made cacheable, yet")
public abstract class TestReport
extends DefaultTask {
    private final DirectoryProperty destinationDir = this.getObjectFactory().directoryProperty();
    private final ConfigurableFileCollection resultDirs = this.getObjectFactory().fileCollection();

    @Inject
    protected BuildOperationRunner getBuildOperationRunner() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected BuildOperationExecutor getBuildOperationExecutor() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @ReplacedBy(value="destinationDirectory")
    @Deprecated
    public File getDestinationDir() {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(TestReport.class, (String)"destinationDir").replaceWith((Object)"destinationDirectory")).willBeRemovedInGradle9().withDslReference().nagUser();
        return ((Directory)this.getDestinationDirectory().get()).getAsFile();
    }

    @Deprecated
    public void setDestinationDir(File destinationDir) {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(TestReport.class, (String)"destinationDir").replaceWith((Object)"destinationDirectory")).willBeRemovedInGradle9().withDslReference().nagUser();
        this.getDestinationDirectory().set(destinationDir);
    }

    @OutputDirectory
    @ReplacesEagerProperty(replacedAccessors={@ReplacedAccessor(value=ReplacedAccessor.AccessorType.GETTER, name="getDestinationDir"), @ReplacedAccessor(value=ReplacedAccessor.AccessorType.SETTER, name="setDestinationDir")}, binaryCompatibility=ReplacesEagerProperty.BinaryCompatibility.ACCESSORS_KEPT, deprecation=@ReplacedDeprecation(removedIn=ReplacedDeprecation.RemovedIn.GRADLE9, withDslReference=true))
    public DirectoryProperty getDestinationDirectory() {
        return this.destinationDir;
    }

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.NONE)
    public ConfigurableFileCollection getTestResults() {
        return this.resultDirs;
    }

    private void addTo(Object result, ConfigurableFileCollection dirs) {
        if (result instanceof Test) {
            Test test = (Test)((Object)result);
            dirs.from(new Object[]{test.getBinaryResultsDirectory()});
        } else if (result instanceof Iterable) {
            Iterable iterable = (Iterable)result;
            for (Object nested : iterable) {
                this.addTo(nested, dirs);
            }
        } else {
            dirs.from(new Object[]{result});
        }
    }

    @Deprecated
    public void reportOn(Object ... results) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(TestReport.class, (String)"reportOn(Object...)").replaceWith((Object)"testResults")).withAdvice("invoke getTestResults().from(Object...) instead, passing references to Test#getBinaryResultsDirectory() as arguments.")).willBeRemovedInGradle9().withDslReference(TestReport.class, "testResults")).nagUser();
        for (Object result : results) {
            this.addTo(result, this.getTestResults());
        }
    }

    @TaskAction
    void generateReport() {
        TestResultsProvider resultsProvider;
        block3: {
            resultsProvider = this.createAggregateProvider();
            try {
                if (resultsProvider.isHasResults()) {
                    HtmlTestReport testReport = new HtmlTestReport(this.getBuildOperationRunner(), this.getBuildOperationExecutor());
                    testReport.generateReport(resultsProvider, ((Directory)this.getDestinationDirectory().get()).getAsFile());
                    break block3;
                }
                this.getLogger().info("{} - no binary test results found in dirs: {}.", (Object)this.getPath(), (Object)this.getTestResults().getFiles());
                this.setDidWork(false);
            }
            catch (Throwable throwable) {
                CompositeStoppable.stoppable((Object[])new Object[]{resultsProvider}).stop();
                throw throwable;
            }
        }
        CompositeStoppable.stoppable((Object[])new Object[]{resultsProvider}).stop();
    }

    private TestResultsProvider createAggregateProvider() {
        LinkedList resultsProviders = new LinkedList();
        try {
            ConfigurableFileCollection resultDirs = this.getTestResults();
            if (resultDirs.getFiles().size() == 1) {
                return new BinaryResultBackedTestResultsProvider(resultDirs.getSingleFile());
            }
            return new AggregateTestResultsProvider((Iterable)CollectionUtils.collect((Iterable)resultDirs, resultsProviders, BinaryResultBackedTestResultsProvider::new));
        }
        catch (RuntimeException e) {
            CompositeStoppable.stoppable(resultsProviders).stop();
            throw e;
        }
    }
}

