/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import java.net.URI;

public class Attribute {
    public final URI property;
    public final String value;

    public Attribute(URI property, String value) {
        this.property = property;
        this.value = value;
    }

    public URI getProperty() {
        return this.property;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.property.toString() + ":" + this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (!this.property.equals(attribute.property)) {
            return false;
        }
        return this.value.equals(attribute.value);
    }

    public int hashCode() {
        int result = this.property.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public static String propertyKeyForURIBase(Attribute attr, String uriBase) {
        if (attr.getProperty().toString().startsWith(uriBase)) {
            return attr.getProperty().toString().substring(uriBase.length());
        }
        return "<" + attr.getProperty() + ">";
    }
}

