/*
 * Decompiled with CFR 0.152.
 */
package JTrrntzip.SupportedFiles;

import JTrrntzip.SupportedFiles.UnsignedTypes;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public final class EnhancedSeekableByteChannel
extends UnsignedTypes
implements SeekableByteChannel,
Closeable,
AutoCloseable {
    private final SeekableByteChannel sbc;
    private ByteOrder bo;
    private Checksum checksum = null;
    private final ByteBuffer lbb = ByteBuffer.allocate(8);
    private final ByteBuffer ibb = ByteBuffer.allocate(4);
    private final ByteBuffer sbb = ByteBuffer.allocate(2);

    public EnhancedSeekableByteChannel(SeekableByteChannel sbc, ByteOrder bo) {
        this.sbc = sbc;
        this.order(bo);
    }

    public EnhancedSeekableByteChannel order(ByteOrder bo) {
        this.bo = bo;
        this.lbb.order(this.bo);
        this.ibb.order(this.bo);
        this.sbb.order(this.bo);
        return this;
    }

    public final ByteOrder order() {
        return this.bo;
    }

    public final EnhancedSeekableByteChannel put(byte b) throws IOException {
        if (this.checksum != null) {
            this.checksum.update(b);
        }
        this.write(ByteBuffer.wrap(new byte[]{b}));
        return this;
    }

    public final EnhancedSeekableByteChannel put(byte[] b) throws IOException {
        if (this.checksum != null) {
            this.checksum.update(b, 0, b.length);
        }
        this.write(ByteBuffer.wrap(b));
        return this;
    }

    public final EnhancedSeekableByteChannel put(byte[] b, int offset, int len) throws IOException {
        if (this.checksum != null) {
            this.checksum.update(b, offset, len);
        }
        this.write(ByteBuffer.wrap(b, 0, len));
        return this;
    }

    public final EnhancedSeekableByteChannel putLong(long l) throws IOException {
        if (this.checksum != null) {
            this.checksum.update(ByteBuffer.allocate(8).putLong(l).array(), 0, 8);
        }
        this.lbb.clear();
        this.lbb.putLong(l);
        this.lbb.rewind();
        if (this.checksum != null) {
            this.checksum.update(this.lbb.array(), 0, 8);
        }
        this.write(this.lbb);
        return this;
    }

    public final EnhancedSeekableByteChannel putULong(BigInteger l) throws IOException {
        return this.putLong(UnsignedTypes.fromULong(l));
    }

    public final EnhancedSeekableByteChannel putInt(int i) throws IOException {
        this.ibb.clear();
        this.ibb.putInt(i);
        this.ibb.rewind();
        if (this.checksum != null) {
            this.checksum.update(this.ibb.array(), 0, 4);
        }
        this.write(this.ibb);
        return this;
    }

    public final EnhancedSeekableByteChannel putUInt(long i) throws IOException {
        return this.putInt(UnsignedTypes.fromUInt(i));
    }

    public final EnhancedSeekableByteChannel putShort(short s) throws IOException {
        this.sbb.clear();
        this.sbb.putShort(s);
        this.sbb.rewind();
        if (this.checksum != null) {
            this.checksum.update(this.sbb.array(), 0, 2);
        }
        this.write(this.sbb);
        return this;
    }

    public final EnhancedSeekableByteChannel putUShort(int s) throws IOException {
        return this.putShort(UnsignedTypes.fromUShort(s));
    }

    public final byte get() throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(1);
        this.read(bb);
        if (this.checksum != null) {
            this.checksum.update(bb.get());
        }
        return bb.get();
    }

    public final EnhancedSeekableByteChannel get(byte[] dst) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(dst.length);
        this.read(bb);
        bb.rewind();
        bb.get(dst);
        if (this.checksum != null) {
            this.checksum.update(dst, 0, dst.length);
        }
        return this;
    }

    public final EnhancedSeekableByteChannel get(byte[] dst, int offset, int len) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(len);
        this.read(bb);
        bb.rewind();
        bb.get(dst, offset, len);
        if (this.checksum != null) {
            this.checksum.update(dst, offset, len);
        }
        return this;
    }

    public final long getLong() throws IOException {
        this.lbb.clear();
        this.read(this.lbb);
        if (this.checksum != null) {
            this.checksum.update(this.lbb.array(), 0, 8);
        }
        this.lbb.rewind();
        return this.lbb.getLong();
    }

    public final BigInteger getULong() throws IOException {
        return UnsignedTypes.toULong(this.getLong());
    }

    public final int getInt() throws IOException {
        this.ibb.clear();
        this.read(this.ibb);
        if (this.checksum != null) {
            this.checksum.update(this.ibb.array(), 0, 4);
        }
        this.ibb.rewind();
        return this.ibb.getInt();
    }

    public final long getUInt() throws IOException {
        return UnsignedTypes.toUInt(this.getInt());
    }

    public final short getShort() throws IOException {
        this.sbb.clear();
        this.read(this.sbb);
        if (this.checksum != null) {
            this.checksum.update(this.sbb.array(), 0, 2);
        }
        this.sbb.rewind();
        return this.sbb.getShort();
    }

    public final int getUShort() throws IOException {
        return UnsignedTypes.toUShort(this.getShort());
    }

    public final InputStream getInputStream() {
        return Channels.newInputStream(this.sbc);
    }

    public final OutputStream getOutputStream() {
        return Channels.newOutputStream(this.sbc);
    }

    @Override
    public final boolean isOpen() {
        return this.sbc.isOpen();
    }

    @Override
    public final void close() throws IOException {
        this.sbc.close();
    }

    @Override
    public final int read(ByteBuffer dst) throws IOException {
        return this.sbc.read(dst);
    }

    @Override
    public final int write(ByteBuffer src) throws IOException {
        return this.sbc.write(src);
    }

    @Override
    public final long position() throws IOException {
        return this.sbc.position();
    }

    @Override
    public final SeekableByteChannel position(long newPosition) throws IOException {
        return this.sbc.position(newPosition);
    }

    @Override
    public final long size() throws IOException {
        return this.sbc.size();
    }

    @Override
    public final SeekableByteChannel truncate(long size) throws IOException {
        return this.sbc.truncate(size);
    }

    public final void startChecksum() {
        this.checksum = new CRC32();
    }

    public final long endChecksum() {
        return this.checksum.getValue();
    }
}

