/*
 * Decompiled with CFR 0.152.
 */
package jrm.io.torrent.bencoding.types;

import java.util.Arrays;
import jrm.io.torrent.bencoding.Utils;
import jrm.io.torrent.bencoding.types.IBencodable;

public class BByteString
implements IBencodable {
    private final byte[] data;

    public BByteString(byte[] data) {
        this.data = data;
    }

    public BByteString(String name) {
        this.data = name.getBytes();
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public String bencodedString() {
        return this.data.length + ":" + new String(this.data);
    }

    @Override
    public byte[] bencode() {
        byte[] lengthStringAsBytes = Utils.stringToAsciiBytes(Long.toString(this.data.length));
        byte[] bencoded = new byte[lengthStringAsBytes.length + 1 + this.data.length];
        bencoded[lengthStringAsBytes.length] = 58;
        System.arraycopy(lengthStringAsBytes, 0, bencoded, 0, lengthStringAsBytes.length);
        for (int i = 0; i < this.data.length; ++i) {
            bencoded[i + lengthStringAsBytes.length + 1] = this.data[i];
        }
        return bencoded;
    }

    public String toString() {
        if (Utils.allAscii(this.data)) {
            return new String(this.data);
        }
        return "<non-ascii bytes:" + this.data.length + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BByteString that = (BByteString)o;
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return this.data != null ? Arrays.hashCode(this.data) : 0;
    }
}

