/*
 * Decompiled with CFR 0.152.
 */
package jupdater;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;

public class JUpdater {
    private final String name;
    private final String project;
    private JsonObject result = null;

    public static void main(String[] args) {
        if (args.length == 0) {
            try {
                Properties props = new Properties();
                props.load(JUpdater.class.getClassLoader().getResourceAsStream("install.properties"));
                JUpdater updater = new JUpdater(props.getProperty("name"), props.getProperty("project"));
                updater.install(props.getProperty("archive"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (args.length == 2) {
            try {
                JUpdater updater = new JUpdater(args[0], args[1]);
                updater.update();
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Bad arguments : " + Arrays.asList(args).stream().collect(Collectors.joining(", ")));
        }
    }

    public JUpdater(String name, String project) {
        this.name = name;
        this.project = project;
        try {
            URL url = new URL("https", "api.github.com", "/repos/" + this.name + "/" + this.project + "/releases/latest");
            this.result = Json.parse((Reader)new BufferedReader(new InputStreamReader(url.openStream(), Charset.forName("UTF-8")))).asObject();
        }
        catch (HeadlessException | IOException e) {
            e.printStackTrace();
        }
    }

    public void update() throws IOException, URISyntaxException {
        URL url = this.getZipURL();
        if (url != null) {
            Path filename = Paths.get(url.getPath(), new String[0]).getFileName();
            try (ProgressMonitorInputStream in = new ProgressMonitorInputStream(null, "Downloading " + filename, url.openStream());){
                Path workdir = Paths.get("", new String[0]).toAbsolutePath();
                Path dir = Paths.get(workdir.toString(), "updates");
                if (Files.notExists(dir, new LinkOption[0])) {
                    Files.createDirectory(dir, new FileAttribute[0]);
                }
                Path file = dir.resolve(filename);
                Files.copy(in, file, StandardCopyOption.REPLACE_EXISTING);
                this.unzip(file, workdir);
                this.launch(workdir);
            }
        }
    }

    public void install(final String archive) throws IOException {
        new JFileChooser(){
            private static final long serialVersionUID = 1L;
            {
                this.setDialogType(1);
                this.setFileSelectionMode(1);
                this.setDialogTitle("Choose directory to install");
                if (this.showSaveDialog(null) == 0) {
                    Path tempDir = Files.createTempDirectory("Install", new FileAttribute[0]);
                    Path tempFile = tempDir.resolve(archive);
                    Files.copy(JUpdater.class.getClassLoader().getResourceAsStream(archive), tempFile, StandardCopyOption.REPLACE_EXISTING);
                    JUpdater.this.unzip(tempFile, this.getSelectedFile().toPath());
                    tempFile.toFile().delete();
                    tempDir.toFile().delete();
                    JUpdater.this.launch(this.getSelectedFile().toPath());
                }
            }
        };
    }

    public void launch(Path workdir) throws IOException {
        String home = System.getProperty("java.home");
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        File java = os.toLowerCase().startsWith("windows") ? new File(new File(home), "bin/javaw.exe") : new File(new File(home), "bin/java");
        String[] stringArray = new String[4];
        stringArray[0] = java.getAbsolutePath();
        stringArray[1] = "-jar";
        stringArray[2] = this.project + ".jar";
        stringArray[3] = arch.equals("x86") ? (os.startsWith("Windows") ? "-Xmx1g" : "-Xmx1500m") : "-Xmx2g";
        new ProcessBuilder(stringArray).directory(workdir.toFile()).start();
        System.exit(0);
    }

    public void unzip(Path zipFile, final Path destDir) throws IOException {
        if (Files.notExists(destDir, new LinkOption[0])) {
            Files.createDirectories(destDir, new FileAttribute[0]);
        }
        try (FileSystem zipFileSystem = FileSystems.newFileSystem(zipFile, null);){
            Path root = zipFileSystem.getRootDirectories().iterator().next();
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path destFile = Paths.get(destDir.toString(), file.toString());
                    try {
                        Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    }
                    catch (DirectoryNotEmptyException directoryNotEmptyException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path dirToCreate = Paths.get(destDir.toString(), dir.toString());
                    if (Files.notExists(dirToCreate, new LinkOption[0])) {
                        Files.createDirectory(dirToCreate, new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public String getChangeLog() {
        StringBuffer buffer = new StringBuffer();
        try {
            JsonValue value;
            JsonObject release;
            URL url = new URL("https", "api.github.com", "/repos/" + this.name + "/" + this.project + "/releases");
            String current_version = this.getVersion();
            Iterator iterator = Json.parse((Reader)new BufferedReader(new InputStreamReader(url.openStream(), Charset.forName("UTF-8")))).asArray().iterator();
            while (iterator.hasNext() && !(release = (value = (JsonValue)iterator.next()).asObject()).getString("tag_name", "").equals(current_version)) {
                String body = release.getString("body", "");
                Parser parser = Parser.builder().build();
                Node node = parser.parse(body);
                HtmlRenderer renderer = HtmlRenderer.builder().build();
                body = renderer.render(node);
                buffer.append("<blockquote>").append("<h4><u>").append(release.getString("name", "")).append("</u></h4>").append(body).append("<br>").append("</blockquote>");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public boolean updateAvailable() {
        if (this.result == null) {
            return false;
        }
        try {
            Files.deleteIfExists(Paths.get("JUpdater.tmp.jar", new String[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String current_version = this.getVersion();
        String new_version = this.result.getString("tag_name", "");
        if (current_version.isEmpty()) {
            return false;
        }
        if (new_version.isEmpty()) {
            return false;
        }
        return !current_version.equals(new_version);
    }

    public String getUpdateName() {
        return this.result.getString("name", this.result.getString("tag_name", ""));
    }

    public URL getZipURL() {
        for (JsonValue asset : this.result.get("assets").asArray()) {
            JsonObject object = asset.asObject();
            if (!object.getString("content_type", "").equals("application/x-zip-compressed")) continue;
            try {
                return new URL(object.getString("browser_download_url", null));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    public void showMessage() {
        JOptionPane.showMessageDialog(null, new JScrollPane(new JEditorPane(){
            private static final long serialVersionUID = 1L;
            {
                JLabel label = new JLabel();
                Font font = label.getFont();
                StringBuffer style = new StringBuffer();
                style.append("font-family:" + font.getFamily() + ";");
                this.setContentType("text/html");
                this.setText(String.format("<html><body style=\"" + style + "\"><h1>New JRomManager %s is available click <a href='javascript:update()' target='_blank'>HERE</a> to update</h1><h2>CHANGELOG</h2>%s</body></html>", JUpdater.this.getUpdateName(), JUpdater.this.getChangeLog()));
                this.addHyperlinkListener(e -> {
                    if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        if ("javascript:update()".equals(e.getDescription())) {
                            try {
                                String home = System.getProperty("java.home");
                                String os = System.getProperty("os.name");
                                File java = os.toLowerCase().startsWith("windows") ? new File(new File(home), "bin/javaw.exe") : new File(new File(home), "bin/java");
                                Path workdir = Paths.get("", new String[0]).toAbsolutePath();
                                Files.copy(workdir.resolve("JUpdater.jar"), workdir.resolve("JUpdater.tmp.jar"), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                                String[] args = new String[]{java.getAbsolutePath(), "-jar", "JUpdater.tmp.jar", JUpdater.this.name, JUpdater.this.project};
                                new ProcessBuilder(args).directory(workdir.toFile()).start();
                                System.exit(0);
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        } else if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                            try {
                                Desktop.getDesktop().browse(e.getURL().toURI());
                            }
                            catch (IOException | URISyntaxException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                });
                this.setEditable(false);
                this.setOpaque(false);
            }
        }){
            private static final long serialVersionUID = 1L;
            {
                this.setVerticalScrollBarPolicy(22);
                this.setPreferredSize(new Dimension(this.getPreferredSize().width, 400));
                this.setBorder(new EmptyBorder(0, 0, 0, 0));
            }
        });
    }

    private String getVersion() {
        String version = "";
        Package pkg = this.getClass().getPackage();
        if (pkg.getSpecificationVersion() != null) {
            version = version + pkg.getSpecificationVersion();
        }
        if (pkg.getImplementationVersion() != null) {
            version = version + pkg.getImplementationVersion();
        }
        return version;
    }
}

