/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.builder;

import groovy.lang.MetaProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.spockframework.builder.BuilderHelper;
import org.spockframework.builder.ISlot;
import org.spockframework.gentyref.GenericTypeReflector;
import org.spockframework.util.MopUtil;
import org.spockframework.util.UnreachableCodeError;

public class CollectionSlot
implements ISlot {
    private final String name;
    private final Object owner;
    private final Type ownerType;
    private final MetaProperty property;

    CollectionSlot(String name, Object owner, Type ownerType, MetaProperty property) {
        this.name = name;
        this.owner = owner;
        this.ownerType = ownerType;
        this.property = property;
    }

    @Override
    public Type getType() {
        Type type = this.getCollectionType();
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        if (type instanceof Class) {
            return Object.class;
        }
        throw new UnreachableCodeError();
    }

    private Type getCollectionType() {
        Method getter = MopUtil.getterFor(this.property);
        if (getter != null) {
            return GenericTypeReflector.getExactReturnType(getter, this.ownerType);
        }
        Field field = MopUtil.fieldFor(this.property);
        if (field != null) {
            return GenericTypeReflector.getExactFieldType(field, this.ownerType);
        }
        throw new UnreachableCodeError();
    }

    @Override
    public void write(Object value) {
        Collection collection = (Collection)this.property.getProperty(this.owner);
        if (collection == null) {
            if (MopUtil.isWriteable(this.property)) {
                collection = this.createCollection(this.property.getType());
                this.property.setProperty(this.owner, (Object)collection);
            } else {
                throw new RuntimeException(String.format("Cannot add element to collection property '%s' because it is neither initialized nor does it have a setter", this.name));
            }
        }
        collection.add(value);
    }

    private Collection createCollection(Class clazz) {
        if ((clazz.getModifiers() & 0x400) == 0) {
            return (Collection)BuilderHelper.createInstance(clazz, new Object[0]);
        }
        if (List.class.isAssignableFrom(clazz)) {
            return new ArrayList();
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return new HashSet();
        }
        throw new RuntimeException(String.format("Don't know how to create a collection of type '%s'", clazz.getName()));
    }
}

