/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.IRewriteResources;
import org.spockframework.compiler.InvalidSpecCompileException;
import org.spockframework.lang.Wildcard;
import org.spockframework.util.Assert;
import org.spockframework.util.ObjectUtil;
import org.spockframework.util.UnreachableCodeError;

public class InteractionRewriter {
    private final IRewriteResources resources;
    private final ClosureExpression activeWithOrMockClosure;
    private ExpressionStatement stat;
    private Expression count;
    private Expression call;
    private boolean wildcardCall;
    private boolean implicitTarget;
    private List<InteractionResponse> responses = new ArrayList<InteractionResponse>();
    private Expression builderExpr;

    public InteractionRewriter(IRewriteResources resources, ClosureExpression activeWithOrMockClosure) {
        this.resources = resources;
        this.activeWithOrMockClosure = activeWithOrMockClosure;
    }

    public ExpressionStatement rewrite(ExpressionStatement stat) {
        try {
            if (!this.isInteraction(stat)) {
                return null;
            }
            this.createBuilder();
            this.setCount();
            this.setCall();
            this.addResponses();
            this.build();
            return this.register();
        }
        catch (InvalidSpecCompileException e) {
            this.resources.getErrorReporter().error(e);
            return null;
        }
    }

    private boolean isInteraction(ExpressionStatement stat) throws InvalidSpecCompileException {
        boolean interaction;
        this.stat = stat;
        Expression expr = this.parseCount(this.parseResults(stat.getExpression()));
        boolean bl = interaction = (this.count != null || !this.responses.isEmpty()) && this.parseCall(expr);
        if (interaction && ((MethodNode)this.resources.getCurrentMethod().getAst()).isStatic()) {
            throw new InvalidSpecCompileException((ASTNode)stat, "Interactions cannot be declared in static scope", new Object[0]);
        }
        return interaction;
    }

    private Expression parseResults(Expression expr) {
        BinaryExpression binExpr;
        int type;
        while (expr instanceof BinaryExpression && ((type = (binExpr = (BinaryExpression)expr).getOperation().getType()) == 281 || type == 282)) {
            this.responses.add(new InteractionResponse(binExpr.getRightExpression(), type == 282));
            expr = binExpr.getLeftExpression();
        }
        return expr;
    }

    private Expression parseCount(Expression expr) {
        BinaryExpression binExpr = ObjectUtil.asInstance(expr, BinaryExpression.class);
        if (binExpr == null || binExpr.getOperation().getType() != 202) {
            return expr;
        }
        this.count = binExpr.getLeftExpression();
        return binExpr.getRightExpression();
    }

    private boolean parseCall(Expression expr) throws InvalidSpecCompileException {
        this.call = expr;
        if (AstUtil.isWildcardRef(expr)) {
            this.wildcardCall = true;
            this.implicitTarget = this.activeWithOrMockClosure != null;
            return true;
        }
        if (expr instanceof PropertyExpression || expr instanceof MethodCallExpression || expr instanceof ConstructorCallExpression) {
            if (AstUtil.isInvocationWithImplicitThis(expr)) {
                if (this.activeWithOrMockClosure == null || !AstUtil.hasImplicitParameter(this.activeWithOrMockClosure)) {
                    throw new InvalidSpecCompileException((ASTNode)this.call, "Interaction is missing a target", new Object[0]);
                }
                this.implicitTarget = true;
            }
            return true;
        }
        if (expr instanceof StaticMethodCallExpression) {
            return false;
        }
        return false;
    }

    private void createBuilder() {
        Expression expr = this.stat.getExpression();
        this.builderExpr = new ConstructorCallExpression(this.resources.getAstNodeCache().InteractionBuilder, (Expression)new ArgumentListExpression(Arrays.asList(new ConstantExpression((Object)expr.getLineNumber()), new ConstantExpression((Object)expr.getColumnNumber()), new ConstantExpression((Object)this.resources.getSourceText((ASTNode)expr)))));
    }

    private void setCount() {
        if (this.count == null) {
            return;
        }
        if (this.count instanceof RangeExpression) {
            RangeExpression range = (RangeExpression)this.count;
            this.call("setRangeCount", new Expression[]{range.getFrom(), range.getTo(), new ConstantExpression((Object)range.isInclusive())});
            return;
        }
        this.call("setFixedCount", this.count);
    }

    private void setCall() {
        if (this.wildcardCall) {
            if (this.implicitTarget) {
                this.call("addEqualTarget", AstUtil.getImplicitParameterRef(this.activeWithOrMockClosure));
            } else {
                this.call("addWildcardTarget", new Expression[0]);
            }
            this.call("addEqualMethodName", new Expression[]{new ConstantExpression((Object)Wildcard.INSTANCE.toString())});
        } else if (this.call instanceof PropertyExpression) {
            this.setPropertyCall();
        } else if (this.call instanceof MethodCallExpression) {
            this.setMethodCall();
        } else if (this.call instanceof ConstructorCallExpression) {
            this.setConstructorCall();
        } else {
            throw new UnreachableCodeError();
        }
    }

    private void setPropertyCall() {
        this.setTarget();
        this.setPropertyName();
    }

    private void setPropertyName() {
        Expression propertyNameExpr = ((PropertyExpression)this.call).getProperty();
        String constraint = this.selectNameConstraint(propertyNameExpr, "addEqualPropertyName", "addRegexPropertyName");
        this.call(constraint, propertyNameExpr);
    }

    private void setMethodCall() {
        this.setTarget();
        this.setMethodName();
        this.addArgs();
    }

    private void setConstructorCall() {
        this.setTarget();
        this.call("addEqualMethodName", new Expression[]{new ConstantExpression((Object)"<init>")});
        this.addArgs();
    }

    private void setTarget() {
        if (this.implicitTarget) {
            this.call("addEqualTarget", AstUtil.getImplicitParameterRef(this.activeWithOrMockClosure));
        } else {
            this.call("addEqualTarget", AstUtil.getInvocationTarget(this.call));
        }
    }

    private void setMethodName() {
        Expression methodNameExpr = ((MethodCallExpression)this.call).getMethod();
        String constraint = this.selectNameConstraint(methodNameExpr, "addEqualMethodName", "addRegexMethodName");
        this.call(constraint, methodNameExpr);
    }

    private String selectNameConstraint(Expression nameExpr, String constraint1, String constraint2) {
        if (!(nameExpr instanceof ConstantExpression)) {
            return constraint1;
        }
        String method = (String)((ConstantExpression)nameExpr).getValue();
        return AstUtil.isJavaIdentifier(method) ? constraint1 : constraint2;
    }

    private void addArgs() {
        if (this.call instanceof PropertyExpression) {
            return;
        }
        Expression args = AstUtil.getArguments(this.call);
        if (args == ArgumentListExpression.EMPTY_ARGUMENTS) {
            return;
        }
        this.call("setArgListKind", new Expression[]{new ConstantExpression((Object)(args instanceof ArgumentListExpression))});
        if (args instanceof ArgumentListExpression) {
            this.addPositionalArgs((ArgumentListExpression)args);
        } else if (args instanceof NamedArgumentListExpression) {
            this.addNamedArgs((NamedArgumentListExpression)args);
        } else {
            Assert.that(false, "unknown kind of argument list: " + args, new Object[0]);
        }
    }

    private void addPositionalArgs(ArgumentListExpression args) {
        for (Expression arg : args.getExpressions()) {
            this.addArg(arg);
        }
    }

    private void addNamedArgs(NamedArgumentListExpression args) {
        for (MapEntryExpression arg : args.getMapEntryExpressions()) {
            this.addName(arg.getKeyExpression());
            this.addArg(arg.getValueExpression());
        }
    }

    private void addName(Expression name) {
        this.call("addArgName", name);
    }

    private void addArg(Expression arg) {
        if (arg instanceof NotExpression) {
            NotExpression not = (NotExpression)arg;
            this.addArg(not.getExpression());
            this.call("negateLastArg", new Expression[0]);
            return;
        }
        if (arg instanceof CastExpression) {
            CastExpression cast = (CastExpression)arg;
            this.addArg(cast.getExpression());
            this.call("typeLastArg", new Expression[]{new ClassExpression(cast.getType())});
            return;
        }
        if (arg instanceof ClosureExpression) {
            this.call("addCodeArg", arg);
            return;
        }
        this.call("addEqualArg", arg);
    }

    private void addResponses() {
        for (InteractionResponse response : this.responses) {
            if (response.iterable) {
                this.call("addIterableResponse", response.expr);
                continue;
            }
            if (response.expr instanceof ClosureExpression) {
                this.call("addCodeResponse", response.expr);
                continue;
            }
            this.call("addConstantResponse", response.expr);
        }
    }

    private void build() {
        this.call("build", new Expression[0]);
    }

    private ExpressionStatement register() {
        ExpressionStatement result = new ExpressionStatement((Expression)new MethodCallExpression((Expression)this.resources.getMockInvocationMatcher(), "addInteraction", (Expression)new ArgumentListExpression(this.builderExpr)));
        result.setSourcePosition((ASTNode)this.stat);
        return result;
    }

    private void call(String method, Expression ... args) {
        this.builderExpr = new MethodCallExpression(this.builderExpr, method, (Expression)new ArgumentListExpression(args));
    }

    private static class InteractionResponse {
        final Expression expr;
        final boolean iterable;

        private InteractionResponse(Expression expr, boolean iterable) {
            this.expr = expr;
            this.iterable = iterable;
        }
    }
}

