/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.spockframework.runtime.AbstractRunListener;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.SpecInfo;

public class RevertMetaClassRunListener
extends AbstractRunListener {
    private final Map<Class<?>, MetaClass> specLevelSavedMetaClasses = new HashMap();
    private final Map<Class<?>, MetaClass> methodLevelSavedMetaClasses = new HashMap();
    private final Set<Class<?>> specRestorations;
    private final Map<String, Set<Class<?>>> methodRestorations;

    public RevertMetaClassRunListener(Set<Class<?>> specRestorations, Map<String, Set<Class<?>>> methodRestorations) {
        this.specRestorations = specRestorations;
        this.methodRestorations = methodRestorations;
    }

    @Override
    public void beforeSpec(SpecInfo spec) {
        if (this.specRestorations.isEmpty()) {
            return;
        }
        this.saveMetaClassesInto(this.specRestorations, this.specLevelSavedMetaClasses);
    }

    @Override
    public void beforeFeature(FeatureInfo feature) {
        if (feature.isParameterized()) {
            return;
        }
        if (this.methodRestorations.isEmpty()) {
            return;
        }
        String methodName = ((Method)feature.getFeatureMethod().getReflection()).getName();
        if (!this.methodRestorations.containsKey(methodName)) {
            return;
        }
        this.saveMetaClassesInto(this.methodRestorations.get(methodName), this.methodLevelSavedMetaClasses);
    }

    @Override
    public void beforeIteration(IterationInfo iteration) {
        if (!((FeatureInfo)iteration.getParent()).isParameterized()) {
            return;
        }
        if (this.methodRestorations.isEmpty()) {
            return;
        }
        String methodName = ((Method)((FeatureInfo)iteration.getParent()).getFeatureMethod().getReflection()).getName();
        if (!this.methodRestorations.containsKey(methodName)) {
            return;
        }
        this.saveMetaClassesInto(this.methodRestorations.get(methodName), this.methodLevelSavedMetaClasses);
    }

    @Override
    public void afterIteration(IterationInfo iteration) {
        if (!((FeatureInfo)iteration.getParent()).isParameterized()) {
            return;
        }
        if (this.methodLevelSavedMetaClasses.isEmpty()) {
            return;
        }
        this.revertMetaClassesFromAndClear(this.methodLevelSavedMetaClasses);
    }

    @Override
    public void afterFeature(FeatureInfo feature) {
        if (feature.isParameterized()) {
            return;
        }
        if (this.methodLevelSavedMetaClasses.isEmpty()) {
            return;
        }
        this.revertMetaClassesFromAndClear(this.methodLevelSavedMetaClasses);
    }

    @Override
    public void afterSpec(SpecInfo spec) {
        if (this.specRestorations.isEmpty()) {
            return;
        }
        this.revertMetaClassesFromAndClear(this.specLevelSavedMetaClasses);
    }

    private void saveMetaClassesInto(Set<Class<?>> toSave, Map<Class<?>, MetaClass> into) {
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        for (Class<?> clazz : toSave) {
            into.put(clazz, registry.getMetaClass(clazz));
            ExpandoMetaClass newMetaClass = new ExpandoMetaClass(clazz, true, true);
            newMetaClass.initialize();
            registry.setMetaClass(clazz, (MetaClass)newMetaClass);
        }
    }

    private void revertMetaClassesFromAndClear(Map<Class<?>, MetaClass> savedMetaClasses) {
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        for (Map.Entry<Class<?>, MetaClass> entry : savedMetaClasses.entrySet()) {
            Class<?> clazz = entry.getKey();
            MetaClass originalMetaClass = entry.getValue();
            registry.removeMetaClass(clazz);
            registry.setMetaClass(clazz, originalMetaClass);
        }
        savedMetaClasses.clear();
    }
}

