/*
 * Copyright (C) 2002-2008 The Warp Rogue Team
 * Part of the Warp Rogue Project
 *
 * This software is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License.
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY.
 *
 * See the license.txt file for more details.
 */

/*
 * Module: Terrain Files
 */

#include "wrogue.h"


static void		load_terrain_file(const char *);



/*
 * loads the terrain files
 */
void load_terrain_files(void)
{
        const char *file;
        
        adir_files(ADIR_APP_DATA, "data/terrain/");

        while ((file = adir_file_with_path()) != NULL) {

                load_terrain_file(file);
        }

        terrain_box_optimise();
}



/*
 * loads a terrain file
 */
static void load_terrain_file(const char *path)
{
        TERRAIN *terrain = NULL;

        rdb_open(path, RDB_READ);

        while (rdb_next_field()) {
                const char *field_name;

                field_name = rdb_field_name();

                if (strings_equal(field_name, "NAME")) {

                        terrain = terrain_box_new_terrain();

                        read_name_field(terrain->name,
                                TERRAIN_NAME_SIZE
                        );

                } else if (strings_equal(field_name, "SYMBOL")) {

                        read_symbol_field(&terrain->symbol);

                } else if (strings_equal(field_name, "COLOUR")) {

                        read_dynamic_colour_field(&terrain->colour);

                } else if (strings_equal(field_name, "ATTRIBUTE")) {
                        TERRAIN_ATTRIBUTE attribute;

                        attribute = name_to_terrain_attribute(
                                rdb_data_token(RDB_NEXT_TOKEN)
                        );

                        terrain_set_attribute(terrain, attribute);

                } else if (strings_equal(field_name, "DESCRIPTION")) {

                        read_description_field(terrain->description,
                                terrain->name
                        );

                } else {

                        die("*** CORE ERROR *** invalid field name: " \
                                "%s (%s)",
                                field_name,
                                path
                        );
                }
        }

        rdb_close();
}


