/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.application;

import com.jgoodies.application.Application;
import com.jgoodies.application.BlockingScope;
import com.jgoodies.application.InputBlocker;
import com.jgoodies.application.Task;
import com.jgoodies.common.base.Preconditions;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;

public abstract class AbstractInputBlocker
implements InputBlocker {
    private static final Map<Object, Integer> COUNTER_MAP = new HashMap<Object, Integer>();
    private static final Map<Object, Boolean> ENABLED_MAP = new HashMap<Object, Boolean>();
    private Level logLevel = Level.FINE;

    @Override
    public void block(Task<?, ?> task) {
        Preconditions.checkState(EventQueue.isDispatchThread(), "#block must run on the event dispatching thread (EDT).");
        switch (task.getBlockingScope()) {
            case NONE: {
                throw new IllegalStateException("An InputBlocker must not be invoked with a BlockingScope.NONE.");
            }
            case ACTION: {
                this.block(task, task.getAction());
                break;
            }
            case COMPONENT: {
                this.block(task, task.getComponent());
                break;
            }
            case WINDOW: {
                this.block(task, task.getWindow());
                break;
            }
            case APPLICATION: {
                this.block(task, AbstractInputBlocker.getApplication());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown blocking scope: " + (Object)((Object)task.getBlockingScope()));
            }
        }
    }

    @Override
    public void unblock(Task<?, ?> task) {
        Preconditions.checkState(EventQueue.isDispatchThread(), "#unblock must run on the event dispatching thread (EDT).");
        switch (task.getBlockingScope()) {
            case NONE: {
                throw new IllegalStateException("An InputBlocker must not be invoked with a BlockingScope.NONE.");
            }
            case ACTION: {
                this.unblock(task, task.getAction());
                break;
            }
            case COMPONENT: {
                this.unblock(task, task.getComponent());
                break;
            }
            case WINDOW: {
                this.unblock(task, task.getWindow());
                break;
            }
            case APPLICATION: {
                this.unblock(task, AbstractInputBlocker.getApplication());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown blocking scope: " + (Object)((Object)task.getBlockingScope()));
            }
        }
    }

    protected void block(Task<?, ?> task, Action action) {
        this.logBlock(task, BlockingScope.ACTION, action);
        action.setEnabled(false);
    }

    protected void block(Task<?, ?> task, Component component) {
        if (component == null) {
            this.logScopeExpansion(task, BlockingScope.COMPONENT, null, BlockingScope.APPLICATION, AbstractInputBlocker.getApplication());
            this.block(task, AbstractInputBlocker.getApplication());
            return;
        }
        int oldCounter = AbstractInputBlocker.increaseBlockingCounter(component);
        this.block(task, component, oldCounter);
    }

    protected void block(Task<?, ?> task, Component c, int oldCounter) {
        this.logBlock(task, BlockingScope.COMPONENT, c);
        if (oldCounter == 0) {
            ENABLED_MAP.put(c, c.isEnabled());
        }
        c.setEnabled(false);
    }

    protected void block(Task<?, ?> task, Window window) {
        if (window == null) {
            this.logScopeExpansion(task, BlockingScope.WINDOW, null, BlockingScope.APPLICATION, AbstractInputBlocker.getApplication());
            this.block(task, AbstractInputBlocker.getApplication());
            return;
        }
        int oldCounter = AbstractInputBlocker.increaseBlockingCounter(window);
        this.block(task, window, oldCounter);
    }

    protected abstract void block(Task<?, ?> var1, Window var2, int var3);

    protected void block(Task<?, ?> task, Application application) {
        int oldCounter = AbstractInputBlocker.increaseBlockingCounter(application);
        this.logBlock(task, BlockingScope.APPLICATION, application);
        this.block(task, application, oldCounter);
    }

    protected abstract void block(Task<?, ?> var1, Application var2, int var3);

    protected void unblock(Task<?, ?> task, Action action) {
        this.logUnblock(task, BlockingScope.ACTION, action);
        action.setEnabled(true);
    }

    protected void unblock(Task<?, ?> task, Component component) {
        if (component == null) {
            this.logScopeExpansion(task, BlockingScope.COMPONENT, null, BlockingScope.APPLICATION, AbstractInputBlocker.getApplication());
            this.unblock(task, AbstractInputBlocker.getApplication());
            return;
        }
        int newCounter = AbstractInputBlocker.decreaseBlockingCounter(component);
        this.unblock(task, component, newCounter);
    }

    protected void unblock(Task<?, ?> task, Component c, int newCounter) {
        if (newCounter == 0) {
            Boolean oldEnabledState = ENABLED_MAP.get(c);
            c.setEnabled(oldEnabledState);
        }
    }

    protected void unblock(Task<?, ?> task, Window window) {
        if (window == null) {
            this.logScopeExpansion(task, BlockingScope.WINDOW, null, BlockingScope.APPLICATION, AbstractInputBlocker.getApplication());
            this.unblock(task, AbstractInputBlocker.getApplication());
            return;
        }
        int newCounter = AbstractInputBlocker.decreaseBlockingCounter(window);
        this.unblock(task, window, newCounter);
    }

    protected abstract void unblock(Task<?, ?> var1, Window var2, int var3);

    protected void unblock(Task<?, ?> task, Application application) {
        int newCounter = AbstractInputBlocker.decreaseBlockingCounter(application);
        this.logUnblock(task, BlockingScope.APPLICATION, application);
        this.unblock(task, application, newCounter);
    }

    protected abstract void unblock(Task<?, ?> var1, Application var2, int var3);

    public final Level getLogLevel() {
        return this.logLevel;
    }

    public final void setLogLevel(Level newLevel) {
        this.logLevel = newLevel;
    }

    protected void logBlock(Task<?, ?> task, BlockingScope scope, Object target) {
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.log(this.getLogLevel(), "Block: Task title=" + task.getTitle() + "; scope=" + (Object)((Object)scope) + "; target=" + AbstractInputBlocker.name(target));
    }

    protected void logUnblock(Task<?, ?> task, BlockingScope scope, Object target) {
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.log(this.getLogLevel(), "Unblock: Task title=" + task.getTitle() + "; scope=" + (Object)((Object)scope) + "; target=" + AbstractInputBlocker.name(target));
    }

    protected void logScopeExpansion(Task<?, ?> task, BlockingScope oldScope, Object oldTarget, BlockingScope newScope, Object newTarget) {
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.log(this.getLogLevel(), "BlockingScope expansion: \nold scope=" + (Object)((Object)oldScope) + "; old target=" + AbstractInputBlocker.name(oldTarget) + "\nnew scope=" + (Object)((Object)newScope) + "; new target=" + AbstractInputBlocker.name(newTarget));
    }

    private static String name(Object target) {
        if (target == null) {
            return "null";
        }
        return target instanceof Action ? (String)((Action)target).getValue("Name") : target.toString();
    }

    protected static final Application getApplication() {
        return Application.getInstance();
    }

    public static final int getBlockingCounter(Object target) {
        Integer counter = COUNTER_MAP.get(target);
        if (counter == null) {
            counter = 0;
        }
        return counter;
    }

    public static final int increaseBlockingCounter(Object target) {
        int oldValue = AbstractInputBlocker.getBlockingCounter(target);
        COUNTER_MAP.put(target, oldValue + 1);
        return oldValue;
    }

    public static final int decreaseBlockingCounter(Object target) {
        Integer counter = COUNTER_MAP.get(target);
        if (counter == null) {
            Preconditions.checkState(target instanceof Window, "The unblock target %s  must have a blocking counter set.", target);
            counter = 0;
        }
        if ((counter = Integer.valueOf(counter - 1)) == 0) {
            COUNTER_MAP.remove(target);
        } else if (counter > 0) {
            COUNTER_MAP.put(target, counter);
        }
        return counter;
    }
}

