/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.application;

import com.jgoodies.application.Application;
import com.jgoodies.application.DefaultResourceMap;
import com.jgoodies.application.ResourceManager;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.common.base.Preconditions;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;

public class DefaultResourceManager
implements ResourceManager {
    private final Class<? extends Application> applicationClass;
    private final Map<Class<?>, ResourceMap> classResourceMapCache;
    private final Map<Package, ResourceMap> packageResourceMapCache;
    private ResourceMap cachedApplicationResourceMap;
    private Locale cachedLocale;

    public DefaultResourceManager(Class<? extends Application> applicationClass) {
        this.applicationClass = Preconditions.checkNotNull(applicationClass, "The %s must not be null.", "application class");
        this.classResourceMapCache = Collections.synchronizedMap(new WeakHashMap());
        this.packageResourceMapCache = Collections.synchronizedMap(new WeakHashMap());
    }

    @Override
    public ResourceMap getResourceMap() {
        this.ensureValidCache();
        if (this.cachedApplicationResourceMap == null) {
            this.cachedApplicationResourceMap = this.createApplicationResourceMap();
        }
        return this.cachedApplicationResourceMap;
    }

    @Override
    public ResourceMap getResourceMap(Class<?> type) {
        if (type == null) {
            return this.getResourceMap();
        }
        this.ensureValidCache();
        ResourceMap resourceMap = this.classResourceMapCache.get(type);
        if (resourceMap != null) {
            return resourceMap;
        }
        ResourceMap parentMap = this.getResourceMap(type.getPackage(), type);
        ResourceMap classResourceMap = this.createResourceMap(parentMap, type);
        resourceMap = classResourceMap.getBundle() == null ? parentMap : classResourceMap;
        this.classResourceMapCache.put(type, resourceMap);
        return resourceMap;
    }

    @Override
    public void clear() {
        this.cachedApplicationResourceMap = null;
        this.classResourceMapCache.clear();
        this.packageResourceMapCache.clear();
    }

    protected ResourceMap getResourceMap(Package aPackage, Class<?> type) {
        this.ensureValidCache();
        ResourceMap resourceMap = this.packageResourceMapCache.get(aPackage);
        if (resourceMap != null) {
            return resourceMap;
        }
        ResourceMap parentMap = this.getResourceMap();
        ResourceMap packageResourceMap = this.createResourceMap(parentMap, this.createPackageBundleBaseName(type), Locale.getDefault(), type.getClassLoader());
        resourceMap = packageResourceMap.getBundle() == null ? parentMap : packageResourceMap;
        this.packageResourceMapCache.put(aPackage, resourceMap);
        return resourceMap;
    }

    private ResourceMap createApplicationResourceMap() {
        return this.getApplicationClass() == null ? this.createResourceMap(null, Application.class) : this.createApplicationResourceMap(this.getApplicationClass());
    }

    protected ResourceMap createApplicationResourceMap(Class<?> type) {
        if (type == Application.class) {
            return null;
        }
        ResourceMap parentMap = this.createApplicationResourceMap(type.getSuperclass());
        ResourceMap typeMap = this.createResourceMap(parentMap, type);
        return typeMap.getBundle() == null ? parentMap : typeMap;
    }

    protected ResourceMap createResourceMap(ResourceMap parent, Class<?> type) {
        return this.createResourceMap(parent, this.createClassBundleBaseName(type), Locale.getDefault(), type.getClassLoader());
    }

    protected ResourceMap createResourceMap(ResourceMap parent, String bundleBaseName, Locale locale, ClassLoader loader) {
        return new DefaultResourceMap(parent, bundleBaseName, locale, loader);
    }

    protected String createPackageBundleBaseName(Class<?> type) {
        return DefaultResourceManager.defaultPackageBundleBaseName(type);
    }

    protected String createClassBundleBaseName(Class<?> type) {
        return DefaultResourceManager.defaultClassBundleBaseName(type);
    }

    protected void ensureValidCache() {
        if (!Locale.getDefault().equals(this.cachedLocale)) {
            this.clear();
            this.cachedLocale = Locale.getDefault();
        }
    }

    public static String defaultPackageBundleBaseName(Class<?> type) {
        return type.getPackage().getName() + ".resources.Package";
    }

    public static String defaultClassBundleBaseName(Class<?> type) {
        String packageName = type.getPackage().getName();
        String className = type.getSimpleName();
        return packageName + ".resources." + className;
    }

    private Class<? extends Application> getApplicationClass() {
        return this.applicationClass;
    }
}

