/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class JGSplitPane
extends JSplitPane {
    public static final String PROPERTY_DIVIDER_BORDER_VISIBLE = "dividerBorderVisible";
    private boolean dividerBorderVisible = false;

    public JGSplitPane() {
        this(1, false, new JButton(UIManager.getString("SplitPane.leftButtonText")), new JButton(UIManager.getString("SplitPane.rightButtonText")));
    }

    public JGSplitPane(int newOrientation) {
        this(newOrientation, false);
    }

    public JGSplitPane(int newOrientation, boolean newContinuousLayout) {
        this(newOrientation, newContinuousLayout, null, null);
    }

    public JGSplitPane(int orientation, Component leftComponent, Component rightComponent) {
        this(orientation, false, leftComponent, rightComponent);
    }

    public JGSplitPane(int orientation, boolean continuousLayout, Component leftComponent, Component rightComponent) {
        super(orientation, continuousLayout, leftComponent, rightComponent);
    }

    public boolean isDividerBorderVisible() {
        return this.dividerBorderVisible;
    }

    public void setDividerBorderVisible(boolean newVisibility) {
        boolean oldVisibility = this.isDividerBorderVisible();
        if (oldVisibility == newVisibility) {
            return;
        }
        this.dividerBorderVisible = newVisibility;
        this.firePropertyChange(PROPERTY_DIVIDER_BORDER_VISIBLE, oldVisibility, newVisibility);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (!this.isDividerBorderVisible()) {
            this.setEmptyDividerBorder();
        }
    }

    private void setEmptyDividerBorder() {
        SplitPaneUI splitPaneUI = this.getUI();
        if (splitPaneUI instanceof BasicSplitPaneUI) {
            BasicSplitPaneUI basicUI = (BasicSplitPaneUI)splitPaneUI;
            basicUI.getDivider().setBorder(BorderFactory.createEmptyBorder());
        }
    }
}

