/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane.form;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.dialogs.core.CloseRequestHandler;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.pane.form.FormPaneModel;
import java.awt.event.ActionEvent;

public abstract class AbstractFormPaneModel
extends Bean
implements FormPaneModel {
    private String markedAcceptText;
    private final boolean applyVisible;
    private boolean applyEnabled;

    public AbstractFormPaneModel() {
        this(CommandValue.SAVE);
    }

    public AbstractFormPaneModel(CommandValue acceptValue) {
        this(Preconditions.checkNotNull(acceptValue, "The %s must not be null.", "accept value").getMarkedText());
    }

    public AbstractFormPaneModel(String markedAcceptText) {
        this(markedAcceptText, false, false);
    }

    public AbstractFormPaneModel(CommandValue acceptValue, boolean applyVisible, boolean applyEnabled) {
        this(Preconditions.checkNotNull(acceptValue, "The %s must not be null.", "accept value").getMarkedText(), applyVisible, applyEnabled);
    }

    public AbstractFormPaneModel(String markedAcceptText, boolean applyVisible, boolean applyEnabled) {
        this.markedAcceptText = Preconditions.checkNotBlank(markedAcceptText, "The %s must not be null, empty, or whitespace.", "accept text");
        this.applyVisible = applyVisible;
        this.applyEnabled = applyEnabled;
    }

    @Override
    public final String getAcceptText() {
        return this.markedAcceptText;
    }

    public void setAcceptText(String newMarkedAcceptText) {
        Preconditions.checkNotBlank(newMarkedAcceptText, "The %s must not be null, empty, or whitespace.", "accept text");
        String oldText = this.getAcceptText();
        this.markedAcceptText = newMarkedAcceptText;
        this.firePropertyChange("acceptText", oldText, newMarkedAcceptText);
    }

    @Override
    public final boolean isApplyVisible() {
        return this.applyVisible;
    }

    @Override
    public boolean isApplyEnabled() {
        return this.applyEnabled;
    }

    public void setApplyEnabled(boolean b) {
        boolean oldValue = this.isApplyEnabled();
        this.applyEnabled = b;
        this.firePropertyChange("applyEnabled", oldValue, b);
    }

    @Override
    public void onCancelPerformed(ActionEvent e) {
        this.onPaneClosing(e, CloseRequestHandler.NO_OPERATION);
    }
}

