/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane.property;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.dialogs.core.internal.BasicPropertyPaneBuilder;
import com.jgoodies.dialogs.core.pane.property.TreePropertyPane;
import com.jgoodies.layout.builder.FormBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;

public final class TreePropertyPaneBuilder
extends BasicPropertyPaneBuilder<TreePropertyPane, TreePropertyPaneBuilder> {
    public TreePropertyPaneBuilder expandTopLevel() {
        ((TreePropertyPane)this.pane).expandTopLevel();
        return this;
    }

    public TreePropertyPaneBuilder showRootHandles(boolean b) {
        ((TreePropertyPane)this.pane).setShowRootHandles(b);
        return this;
    }

    public TreePropertyPaneBuilder selectionRow(int rowIndex) {
        ((TreePropertyPane)this.pane).setSelectionRow(rowIndex);
        return this;
    }

    public Adder beginTab() {
        return new Adder(this);
    }

    @Override
    protected TreePropertyPane createPane() {
        return new TreePropertyPane();
    }

    DefaultMutableTreeNode addTab(DefaultMutableTreeNode parent, String tabText, String tabTitle, JComponent tabComponent) {
        return ((TreePropertyPane)this.pane).addTabImpl(parent, tabText, tabTitle, tabComponent);
    }

    public static abstract class AbstractAdder<A extends AbstractAdder<?>> {
        protected String text;
        protected String title;
        protected EmptyBorder padding;
        protected boolean paddingSet;
        protected JComponent content;
        protected final List<ChildAdder<?>> childAdders = new ArrayList();

        public A text(String plainText, Object ... args) {
            this.text = Strings.get(plainText, args);
            return (A)this;
        }

        public A title(String markedTitle, Object ... args) {
            this.title = Strings.get(markedTitle, args);
            return (A)this;
        }

        public A padding(EmptyBorder padding) {
            this.padding = padding;
            this.paddingSet = true;
            return (A)this;
        }

        public A content(JComponent tabContent) {
            this.content = tabContent;
            return (A)this;
        }

        public A content(String text, Object ... args) {
            JGComponentFactory factory = JGComponentFactory.getCurrent();
            JTextComponent staticText = factory.createStaticText(text, args);
            JPanel content = ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:pref:grow", new Object[0])).rows("p", new Object[0])).opaque(false)).add(staticText).xy(1, 1)).build();
            return this.content(content);
        }

        protected JComponent getContent() {
            if (this.paddingSet) {
                this.content.setBorder(this.padding);
            }
            return this.content;
        }

        protected void addChild(ChildAdder<?> child) {
            this.childAdders.add(child);
        }

        protected void addTabs(TreePropertyPaneBuilder builder, DefaultMutableTreeNode parentNode) {
            for (ChildAdder<?> childAdder : this.childAdders) {
                DefaultMutableTreeNode node = builder.addTab(parentNode, childAdder.text, childAdder.title, childAdder.getContent());
                childAdder.addTabs(builder, node);
            }
        }
    }

    public static final class Adder
    extends AbstractAdder<Adder> {
        private final TreePropertyPaneBuilder builder;

        Adder(TreePropertyPaneBuilder builder) {
            this.builder = builder;
        }

        public ChildAdder<Adder> beginTab() {
            return new ChildAdder<Adder>(this);
        }

        public TreePropertyPaneBuilder endTab() {
            Preconditions.checkNotBlank(this.text, "The %s must not be null, empty, or whitespace.", "tab text");
            if (this.childAdders.isEmpty()) {
                Preconditions.checkNotNull(this.content, "The %s must not be null.", "tab content");
            } else if (this.content == null) {
                JPanel empty = new JPanel(null);
                empty.setOpaque(false);
                this.content(empty);
            }
            DefaultMutableTreeNode node = this.builder.addTab(null, this.text, this.title, this.getContent());
            this.addTabs(this.builder, node);
            return this.builder;
        }
    }

    public static final class ChildAdder<P extends AbstractAdder<?>>
    extends AbstractAdder<ChildAdder<P>> {
        private final P parent;

        ChildAdder(P parent) {
            this.parent = parent;
        }

        public ChildAdder<ChildAdder<P>> beginTab() {
            return new ChildAdder<ChildAdder<P>>(this);
        }

        public P endTab() {
            Preconditions.checkNotBlank(this.text, "The %s must not be null, empty, or whitespace.", "tab text");
            Preconditions.checkNotNull(this.content, "The %s must not be null.", "tab content");
            ((AbstractAdder)this.parent).addChild(this);
            return this.parent;
        }
    }
}

