/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.skeleton;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import net.charabia.jsmoothgen.skeleton.SkeletonBean;
import net.charabia.jsmoothgen.skeleton.SkeletonPersistency;
import net.charabia.jsmoothgen.skeleton.SkeletonProperty;
import net.charabia.jsmoothgen.skeleton.SkeletonPropertyTableModel;

public class SkeletonEditor
extends JFrame {
    private SkeletonPropertyTableModel m_model = new SkeletonPropertyTableModel();
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JTextField m_categoryName;
    private JCheckBox m_cbDebug;
    private JEditorPane m_description;
    private JTextField m_exeName;
    private JFileChooser m_fileChooser;
    private JTextField m_jarId;
    private JLabel m_labelName;
    private JMenuItem m_menuAddItem;
    private JMenuItem m_menuExit;
    private JMenuItem m_menuItemUp;
    private JMenuItem m_menuLoad;
    private JMenuItem m_menuLoadKBML;
    private JMenuItem m_menuNew;
    private JMenuItem m_menuRemoveItem;
    private JMenuItem m_menuSave;
    private JMenuItem m_menuSaveKbml;
    private JTextField m_name;
    private JPopupMenu m_popupMenu;
    private JTable m_propTable;
    private JTextField m_propsId;
    private JScrollPane m_tablescrollpane;

    public SkeletonEditor() {
        this.initComponents();
        this.setSkeleton(new SkeletonBean());
    }

    private void initComponents() {
        this.m_fileChooser = new JFileChooser();
        this.m_popupMenu = new JPopupMenu();
        this.m_menuAddItem = new JMenuItem();
        this.m_menuRemoveItem = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.m_menuItemUp = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.jLabel5 = new JLabel();
        this.m_exeName = new JTextField();
        this.m_labelName = new JLabel();
        this.m_name = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.m_description = new JEditorPane();
        this.jLabel2 = new JLabel();
        this.m_categoryName = new JTextField();
        this.jLabel3 = new JLabel();
        this.m_jarId = new JTextField();
        this.jLabel4 = new JLabel();
        this.m_propsId = new JTextField();
        this.m_cbDebug = new JCheckBox();
        this.m_tablescrollpane = new JScrollPane();
        this.m_propTable = new JTable();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.m_menuNew = new JMenuItem();
        this.m_menuLoadKBML = new JMenuItem();
        this.m_menuLoad = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.m_menuSaveKbml = new JMenuItem();
        this.m_menuSave = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.m_menuExit = new JMenuItem();
        this.m_fileChooser.setCurrentDirectory(new File("c:\\"));
        this.m_fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.toString().endsWith(".skel")) {
                    return true;
                }
                return f.isDirectory();
            }

            public String getDescription() {
                return "JSmooth Skeletons (*.skel)";
            }
        });
        this.m_fileChooser.setFileSelectionMode(2);
        this.m_menuAddItem.setText("Add item");
        this.m_menuAddItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SkeletonEditor.this.menuAddItemActionPerformed(evt);
            }
        });
        this.m_popupMenu.add(this.m_menuAddItem);
        this.m_menuRemoveItem.setText("RemoveItems");
        this.m_menuRemoveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SkeletonEditor.this.menuRemoveItemActionPerformed(evt);
            }
        });
        this.m_popupMenu.add(this.m_menuRemoveItem);
        this.m_popupMenu.add(this.jSeparator3);
        this.m_menuItemUp.setText("Item Up");
        this.m_menuItemUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SkeletonEditor.this.menuItemUpActionPerformed(evt);
            }
        });
        this.m_popupMenu.add(this.m_menuItemUp);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("JSmooth Skeleton Editor");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SkeletonEditor.this.exitForm(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new EtchedBorder());
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Executable Name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        this.jPanel1.add((Component)this.m_exeName, gridBagConstraints);
        this.m_labelName.setHorizontalAlignment(4);
        this.m_labelName.setText("Short Name");
        this.m_labelName.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel1.add((Component)this.m_labelName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        this.jPanel1.add((Component)this.m_name, gridBagConstraints);
        this.jLabel1.setText("Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.m_description);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Category Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        this.jPanel1.add((Component)this.m_categoryName, gridBagConstraints);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Resource Id for JAR");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.m_jarId, gridBagConstraints);
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Resource Id for Properties");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.m_propsId.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SkeletonEditor.this.m_propsIdActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.m_propsId, gridBagConstraints);
        this.m_cbDebug.setText("Mark this wrapper for debugging only");
        this.m_cbDebug.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.m_cbDebug, gridBagConstraints);
        this.m_tablescrollpane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                SkeletonEditor.this.tablescrollpaneMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                SkeletonEditor.this.tablescrollpaneMouseReleased(evt);
            }
        });
        this.m_propTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}}, new String[]{"Id", "Label", "Description", "Type", "Value"}));
        this.m_propTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SkeletonEditor.this.propTableMouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                SkeletonEditor.this.propTableMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                SkeletonEditor.this.propTableMouseReleased(evt);
            }
        });
        this.m_tablescrollpane.setViewportView(this.m_propTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.m_tablescrollpane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.9;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jMenu1.setText("System");
        this.m_menuNew.setText("New");
        this.m_menuNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SkeletonEditor.this.menuNewActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.m_menuNew);
        this.m_menuLoadKBML.setText("Load");
        this.m_menuLoadKBML.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SkeletonEditor.this.menuLoadKBMLActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.m_menuLoadKBML);
        this.m_menuLoad.setText("Load (deprecated)");
        this.m_menuLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SkeletonEditor.this.menuLoadActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.m_menuLoad);
        this.jMenu1.add(this.jSeparator1);
        this.m_menuSaveKbml.setText("Save");
        this.m_menuSaveKbml.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SkeletonEditor.this.saveKbmlActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.m_menuSaveKbml);
        this.m_menuSave.setText("Save (deprecated)");
        this.m_menuSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SkeletonEditor.this.menuSaveActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.m_menuSave);
        this.jMenu1.add(this.jSeparator2);
        this.m_menuExit.setText("Exit");
        this.jMenu1.add(this.m_menuExit);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 400) / 2, (screenSize.height - 254) / 2, 400, 254);
    }

    private void menuLoadKBMLActionPerformed(ActionEvent evt) {
        if (this.m_fileChooser.showOpenDialog(this) == 0) {
            File f = this.m_fileChooser.getSelectedFile();
            System.out.println("loading " + this.m_fileChooser.getSelectedFile().toString());
            try {
                SkeletonBean skel = SkeletonPersistency.loadWithJox(f);
                this.setSkeleton(skel);
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
        }
    }

    private void saveKbmlActionPerformed(ActionEvent evt) {
        if (this.m_fileChooser.showSaveDialog(this) == 0) {
            File f = this.m_fileChooser.getSelectedFile();
            if (!f.toString().endsWith(".skel")) {
                f = new File(f.getAbsolutePath() + ".skel");
            }
            System.out.println("loading " + this.m_fileChooser.getSelectedFile().toString());
            try {
                SkeletonBean skel = this.getSkeleton();
                SkeletonPersistency.saveWithJox(f, skel);
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
        }
    }

    private void menuItemUpActionPerformed(ActionEvent evt) {
        int selr = this.m_propTable.getSelectedRow();
        if (selr > 0) {
            this.m_model.swapItems(selr, selr - 1);
        }
    }

    private void menuRemoveItemActionPerformed(ActionEvent evt) {
        int selr = this.m_propTable.getSelectedRow();
        if (selr != -1) {
            this.m_model.removeRow(selr);
        }
    }

    private void menuAddItemActionPerformed(ActionEvent evt) {
        SkeletonProperty prop = new SkeletonProperty();
        int selr = this.m_propTable.getSelectedRow();
        if (selr >= 0) {
            this.m_model.add(prop, selr);
        } else {
            this.m_model.add(prop);
        }
    }

    private void tablescrollpaneMouseReleased(MouseEvent evt) {
        System.out.println("MOUSE");
        if (evt.isPopupTrigger()) {
            System.out.println("trigger !");
            this.showPopupMenu(evt, this.m_tablescrollpane);
        }
    }

    private void tablescrollpaneMousePressed(MouseEvent evt) {
        System.out.println("MOUSE");
        if (evt.isPopupTrigger()) {
            System.out.println("trigger !");
            this.showPopupMenu(evt, this.m_tablescrollpane);
        }
    }

    private void propTableMouseReleased(MouseEvent evt) {
        System.out.println("MOUSE");
        if (evt.isPopupTrigger()) {
            System.out.println("trigger !");
            this.showPopupMenu(evt, this.m_propTable);
        }
    }

    private void propTableMousePressed(MouseEvent evt) {
        System.out.println("MOUSE");
        if (evt.isPopupTrigger()) {
            System.out.println("trigger !");
            this.showPopupMenu(evt, this.m_propTable);
        }
    }

    private void propTableMouseClicked(MouseEvent evt) {
        System.out.println("MOUSE");
        if (evt.isPopupTrigger()) {
            System.out.println("trigger !");
            this.showPopupMenu(evt, this.m_propTable);
        }
    }

    private void m_propsIdActionPerformed(ActionEvent evt) {
    }

    private void menuSaveActionPerformed(ActionEvent evt) {
        if (this.m_fileChooser.showSaveDialog(this) == 0) {
            File f = this.m_fileChooser.getSelectedFile();
            if (!f.toString().endsWith(".skel")) {
                f = new File(f.getAbsolutePath() + ".skel");
            }
            System.out.println("loading " + this.m_fileChooser.getSelectedFile().toString());
            try {
                SkeletonBean skel = this.getSkeleton();
                SkeletonPersistency.save(f, skel);
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
        }
    }

    private void menuLoadActionPerformed(ActionEvent evt) {
        if (this.m_fileChooser.showOpenDialog(this) == 0) {
            File f = this.m_fileChooser.getSelectedFile();
            System.out.println("loading " + this.m_fileChooser.getSelectedFile().toString());
            try {
                SkeletonBean skel = SkeletonPersistency.load(f);
                this.setSkeleton(skel);
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
        }
    }

    private void menuNewActionPerformed(ActionEvent evt) {
        SkeletonBean skel = new SkeletonBean();
        this.setSkeleton(skel);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public void setSkeleton(SkeletonBean skel) {
        this.m_name.setText(skel.getShortName());
        this.m_description.setText(skel.getDescription());
        this.m_categoryName.setText(skel.getResourceCategory());
        this.m_jarId.setText(new Integer(skel.getResourceJarId()).toString());
        this.m_propsId.setText(new Integer(skel.getResourcePropsId()).toString());
        this.m_exeName.setText(skel.getExecutableName());
        this.m_cbDebug.setSelected(skel.isDebug());
        this.m_model = new SkeletonPropertyTableModel(skel.getSkeletonProperties());
        TableColumn type = this.m_propTable.getColumnModel().getColumn(3);
        JComboBox<String> typeCombo = new JComboBox<String>();
        typeCombo.addItem(SkeletonProperty.TYPE_STRING);
        typeCombo.addItem(SkeletonProperty.TYPE_TEXTAREA);
        typeCombo.addItem(SkeletonProperty.TYPE_BOOLEAN);
        type.setCellEditor(new DefaultCellEditor(typeCombo));
        this.m_propTable.setModel(this.m_model);
    }

    public SkeletonBean getSkeleton() {
        SkeletonBean skel = new SkeletonBean();
        skel.setExecutableName(this.m_exeName.getText());
        skel.setShortName(this.m_name.getText());
        skel.setDescription(this.m_description.getText());
        skel.setResourceCategory(this.m_categoryName.getText());
        skel.setResourceJarId(Integer.parseInt(this.m_jarId.getText()));
        skel.setResourcePropsId(Integer.parseInt(this.m_propsId.getText()));
        skel.setSkeletonProperties(this.m_model.getProperties());
        skel.setDebug(this.m_cbDebug.isSelected());
        return skel;
    }

    public void showPopupMenu(MouseEvent evt, JComponent comp) {
        int r = this.m_propTable.rowAtPoint(new Point(evt.getX(), evt.getY()));
        if (r != -1) {
            this.m_propTable.setRowSelectionInterval(r, r);
        }
        this.m_popupMenu.show(comp, evt.getX(), evt.getY());
    }

    public static void main(String[] args) {
        new SkeletonEditor().setVisible(true);
    }
}

