/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.DomainSelectionFacet;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.PlayerCharacterTrackingFacet;
import pcgen.cdom.facet.RaceSelectionFacet;
import pcgen.cdom.facet.TemplateSelectionFacet;
import pcgen.cdom.facet.event.ScopeFacetChangeEvent;
import pcgen.cdom.facet.event.ScopeFacetChangeListener;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.ChooseActivation;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.util.Logging;

public class ChooseDriverFacet {
    private final PlayerCharacterTrackingFacet trackingFacet = FacetLibrary.getFacet(PlayerCharacterTrackingFacet.class);
    private RaceSelectionFacet raceSelectionFacet;
    private DomainSelectionFacet domainSelectionFacet;
    private TemplateSelectionFacet templateSelectionFacet;
    private Adder adder = new Adder();
    private Remover remover = new Remover();

    public void setDomainSelectionFacet(DomainSelectionFacet domainSelectionFacet) {
        this.domainSelectionFacet = domainSelectionFacet;
    }

    public void setRaceSelectionFacet(RaceSelectionFacet raceSelectionFacet) {
        this.raceSelectionFacet = raceSelectionFacet;
    }

    public void setTemplateSelectionFacet(TemplateSelectionFacet templateSelectionFacet) {
        this.templateSelectionFacet = templateSelectionFacet;
    }

    public void init() {
        this.raceSelectionFacet.addScopeFacetChangeListener(1000, this.adder);
        this.domainSelectionFacet.addScopeFacetChangeListener(1000, this.adder);
        this.templateSelectionFacet.addScopeFacetChangeListener(1000, this.adder);
        this.raceSelectionFacet.addScopeFacetChangeListener(-1000, this.remover);
        this.domainSelectionFacet.addScopeFacetChangeListener(-1000, this.remover);
        this.templateSelectionFacet.addScopeFacetChangeListener(-1000, this.remover);
    }

    private class Remover
    implements ScopeFacetChangeListener<CharID, CDOMObject, Object> {
        private Remover() {
        }

        @Override
        public void dataAdded(ScopeFacetChangeEvent<CharID, CDOMObject, Object> dfce) {
        }

        @Override
        public void dataRemoved(ScopeFacetChangeEvent<CharID, CDOMObject, Object> dfce) {
            PlayerCharacter pc = ChooseDriverFacet.this.trackingFacet.getPC(dfce.getCharID());
            if (!pc.isAllowInteraction()) {
                return;
            }
            Object assoc = dfce.getCDOMObject();
            CDOMObject cdo = dfce.getScope();
            if (cdo instanceof ChooseDriver) {
                if (ChooseActivation.hasNewChooseToken(cdo)) {
                    ChooseDriver cd = (ChooseDriver)((Object)cdo);
                    this.removeAssoc(ChooserUtilities.getChoiceManager(cd, pc), pc, cd, assoc);
                }
            } else {
                Logging.errorPrint("Object of type " + cdo.getClass() + " was sent to ChooseDriverFacet, but it is not a ChooseDriver");
            }
        }

        private <T> void removeAssoc(ChoiceManagerList<T> aMan, PlayerCharacter pc, ChooseDriver obj, T sel) {
            aMan.removeChoice(pc, obj, sel);
        }
    }

    private class Adder
    implements ScopeFacetChangeListener<CharID, CDOMObject, Object> {
        private Adder() {
        }

        @Override
        public void dataAdded(ScopeFacetChangeEvent<CharID, CDOMObject, Object> dfce) {
            PlayerCharacter pc = ChooseDriverFacet.this.trackingFacet.getPC(dfce.getCharID());
            if (!pc.isAllowInteraction()) {
                return;
            }
            CDOMObject obj = dfce.getScope();
            Object sel = dfce.getCDOMObject();
            if (obj instanceof ChooseDriver) {
                if (ChooseActivation.hasNewChooseToken(obj)) {
                    ChooseDriver cd = (ChooseDriver)((Object)obj);
                    this.addAssoc(ChooserUtilities.getChoiceManager(cd, pc), pc, cd, sel);
                }
            } else {
                Logging.errorPrint("Object of type " + obj.getClass() + " was sent to ChooseDriverFacet, but it is not a ChooseDriver");
            }
        }

        private <T> void addAssoc(ChoiceManagerList<T> aMan, PlayerCharacter pc, ChooseDriver obj, T sel) {
            aMan.applyChoice(pc, obj, sel);
        }

        @Override
        public void dataRemoved(ScopeFacetChangeEvent<CharID, CDOMObject, Object> dfce) {
        }
    }
}

