/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.BonusCheckingFacet;
import pcgen.cdom.facet.PrerequisiteFacet;
import pcgen.cdom.facet.base.AbstractListFacet;
import pcgen.cdom.facet.model.StatFacet;
import pcgen.core.PCStat;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.BonusUtilities;

public class StatBonusFacet {
    private BonusCheckingFacet bonusCheckingFacet;
    private PrerequisiteFacet prerequisiteFacet;
    private StatFacet statFacet;

    public Map<BonusObj, PCStat> getBonusListOfType(CharID id, String aType, String aName) {
        IdentityHashMap<BonusObj, PCStat> aList = new IdentityHashMap<BonusObj, PCStat>();
        for (PCStat stat : ((AbstractListFacet)this.statFacet).getSet(id)) {
            List<BonusObj> bonuses = BonusUtilities.getBonusFromList(stat.getSafeListFor(ListKey.BONUS), aType, aName);
            for (BonusObj bonus : bonuses) {
                aList.put(bonus, stat);
            }
        }
        return aList;
    }

    public double getStatBonusTo(CharID id, String type, String name) {
        Map<BonusObj, PCStat> map = this.getBonusListOfType(id, type.toUpperCase(), name.toUpperCase());
        Iterator<Map.Entry<BonusObj, PCStat>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<BonusObj, PCStat> me = it.next();
            BonusObj bo = me.getKey();
            if (this.prerequisiteFacet.qualifies(id, bo, me.getValue())) continue;
            it.remove();
        }
        return this.bonusCheckingFacet.calcBonus(id, map);
    }

    public void setBonusCheckingFacet(BonusCheckingFacet bonusCheckingFacet) {
        this.bonusCheckingFacet = bonusCheckingFacet;
    }

    public void setPrerequisiteFacet(PrerequisiteFacet prerequisiteFacet) {
        this.prerequisiteFacet = prerequisiteFacet;
    }

    public void setStatFacet(StatFacet statFacet) {
        this.statFacet = statFacet;
    }
}

