/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.processor;

import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.content.Processor;
import pcgen.util.StringPClassUtil;

public class ContextProcessor<T, R extends PrereqObject>
implements Processor<T> {
    private final Processor<T> processor;
    private final CDOMReference<R> contextItems;

    public ContextProcessor(Processor<T> mod, CDOMReference<R> contextRef) {
        if (mod == null) {
            throw new IllegalArgumentException("Processor in ContextProcessor cannot be null");
        }
        if (contextRef == null) {
            throw new IllegalArgumentException("Context in ContextProcessor cannot be null");
        }
        this.processor = mod;
        this.contextItems = contextRef;
    }

    @Override
    public T applyProcessor(T obj, Object context) {
        return context instanceof PrereqObject && this.contextItems.contains((PrereqObject)context) ? this.processor.applyProcessor(obj, context) : obj;
    }

    @Override
    public String getLSTformat() {
        String contextString = this.contextItems.getLSTformat(false);
        StringBuilder sb = new StringBuilder();
        sb.append(this.processor.getLSTformat()).append('|');
        sb.append(StringPClassUtil.getStringFor(this.contextItems.getReferenceClass()));
        sb.append(contextString.indexOf(61) == -1 ? (char)'=' : '.');
        sb.append(contextString);
        return sb.toString();
    }

    @Override
    public Class<T> getModifiedClass() {
        return this.processor.getModifiedClass();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ContextProcessor) {
            ContextProcessor other = (ContextProcessor)obj;
            return this.processor.equals(other.processor) && this.contextItems.equals(other.contextItems);
        }
        return false;
    }

    public int hashCode() {
        return this.processor.hashCode() * 31 - this.contextItems.hashCode();
    }
}

