/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.CachedVariable;
import pcgen.core.character.CharacterSpell;
import pcgen.core.utils.CoreUtility;
import pcgen.io.ExportHandler;
import pcgen.util.Logging;
import pcgen.util.PJEP;
import pcgen.util.PjepPool;

public abstract class VariableProcessor {
    protected String jepIndent = "";
    protected PlayerCharacter pc;
    private int cachePaused;
    private int serial;
    private Map<String, CachedVariable<String>> sVariableCache = new HashMap<String, CachedVariable<String>>();
    private Map<String, CachedVariable<Float>> fVariableCache = new HashMap<String, CachedVariable<Float>>();

    protected Float convertToFloat(String element, String foo) {
        Float d = null;
        try {
            d = new Float(foo);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        Float retVal = null;
        if (d != null && !d.isNaN()) {
            retVal = d;
            if (Logging.isDebugMode()) {
                Logging.debugPrint(this.jepIndent + "export variable for: '" + element + "' = " + d);
            }
        }
        return retVal;
    }

    public VariableProcessor(PlayerCharacter pc) {
        this.pc = pc;
    }

    public Float getVariableValue(CharacterSpell aSpell, String varString, String src, int spellLevelTemp) {
        Float result = this.getJepOnlyVariableValue(aSpell, varString, src, spellLevelTemp);
        if (null == result) {
            result = this.processBrokenParser(aSpell, varString, src, spellLevelTemp);
            String cacheString = this.makeCacheString(aSpell == null ? null : aSpell, varString, src, spellLevelTemp);
            this.addCachedVariable(cacheString, result);
        }
        return result;
    }

    public Float getJepOnlyVariableValue(CharacterSpell aSpell, String varString, String src, int spellLevelTemp) {
        try {
            return new Float(varString);
        }
        catch (NumberFormatException e) {
            String cacheString = this.makeCacheString(aSpell == null ? null : aSpell, varString, src, spellLevelTemp);
            Float total = this.getCachedVariable(cacheString);
            if (total != null) {
                return total;
            }
            CachableResult cRes = this.processJepFormula(aSpell, varString, src);
            if (cRes != null) {
                if (cRes.cachable) {
                    this.addCachedVariable(cacheString, cRes.result);
                }
                return cRes.result;
            }
            return null;
        }
    }

    private String makeCacheString(CharacterSpell aSpell, String varString, String src, int spellLevelTemp) {
        StringBuilder cS = new StringBuilder(varString).append("#").append(src);
        if (aSpell != null) {
            if (aSpell.getSpell() != null) {
                cS.append(aSpell.getSpell().getKeyName());
            }
            cS.append(aSpell.getFixedCasterLevel());
        }
        if (spellLevelTemp > 0) {
            cS.append(spellLevelTemp);
        }
        return cS.toString();
    }

    private Float processBrokenParser(CharacterSpell aSpell, String aString, String src, int spellLevelTemp) {
        Float total = new Float(0.0);
        aString = aString.toUpperCase();
        src = src.toUpperCase();
        while (aString.lastIndexOf(40) >= 0) {
            int x = CoreUtility.innerMostStringStart(aString);
            int y = CoreUtility.innerMostStringEnd(aString);
            if (y < x) {
                Logging.errorPrint("Missing closing parenthesis: " + aString);
                return total;
            }
            String bString = aString.substring(x + 1, y);
            aString = aString.substring(0, x) + this.getVariableValue(aSpell, bString, src, spellLevelTemp) + aString.substring(y + 1);
        }
        String delimiter = "+-/*";
        String valString = "";
        MATH_OP mode = MATH_OP.PLUS;
        MATH_OP nextMode = MATH_OP.PLUS;
        if (aString.startsWith(".IF.")) {
            StringTokenizer aTok = new StringTokenizer(aString.substring(4), ".", true);
            String bString = "";
            Float val1 = null;
            Float val2 = null;
            Float valt = null;
            int comp = 0;
            while (aTok.hasMoreTokens()) {
                String cString = aTok.nextToken();
                if ("GT".equals(cString) || "GTEQ".equals(cString) || "EQ".equals(cString) || "LTEQ".equals(cString) || "LT".equals(cString)) {
                    val1 = this.getVariableValue(aSpell, bString.substring(0, bString.length() - 1), src, spellLevelTemp);
                    aTok.nextToken();
                    bString = "";
                    if ("LT".equals(cString)) {
                        comp = 1;
                        continue;
                    }
                    if ("LTEQ".equals(cString)) {
                        comp = 2;
                        continue;
                    }
                    if ("EQ".equals(cString)) {
                        comp = 3;
                        continue;
                    }
                    if ("GT".equals(cString)) {
                        comp = 4;
                        continue;
                    }
                    if (!"GTEQ".equals(cString)) continue;
                    comp = 5;
                    continue;
                }
                if ("THEN".equals(cString)) {
                    val2 = this.getVariableValue(aSpell, bString.substring(0, bString.length() - 1), src, spellLevelTemp);
                    aTok.nextToken();
                    bString = "";
                    continue;
                }
                if ("ELSE".equals(cString)) {
                    valt = this.getVariableValue(aSpell, bString.substring(0, bString.length() - 1), src, spellLevelTemp);
                    aTok.nextToken();
                    bString = "";
                    continue;
                }
                bString = bString + cString;
            }
            if (val1 != null && val2 != null && valt != null) {
                Float valf = this.getVariableValue(aSpell, bString, src, spellLevelTemp);
                total = valt;
                switch (comp) {
                    case 1: {
                        if (!(val1.doubleValue() >= val2.doubleValue())) break;
                        total = valf;
                        break;
                    }
                    case 2: {
                        if (!(val1.doubleValue() > val2.doubleValue())) break;
                        total = valf;
                        break;
                    }
                    case 3: {
                        if (CoreUtility.doublesEqual(val1.doubleValue(), val2.doubleValue())) break;
                        total = valf;
                        break;
                    }
                    case 4: {
                        if (!(val1.doubleValue() <= val2.doubleValue())) break;
                        total = valf;
                        break;
                    }
                    case 5: {
                        if (!(val1.doubleValue() < val2.doubleValue())) break;
                        total = valf;
                        break;
                    }
                    default: {
                        Logging.errorPrint("ERROR - badly formed statement:" + aString + ":" + val1.toString() + ":" + val2.toString() + ":" + comp);
                        return new Float(0.0);
                    }
                }
                return total;
            }
        }
        for (int i = 0; i < aString.length(); ++i) {
            Float tmp;
            valString = valString + aString.substring(i, i + 1);
            if (i != aString.length() - 1 && "+-/*".lastIndexOf(aString.charAt(i)) <= -1 || valString.length() == 1 && "+-/*".lastIndexOf(aString.charAt(i)) > -1) continue;
            if ("+-/*".lastIndexOf(aString.charAt(i)) > -1) {
                valString = valString.substring(0, valString.length() - 1);
            }
            if ((tmp = this.lookupVariable(valString, src, aSpell)) != null) {
                valString = tmp.toString();
            }
            if (i < aString.length()) {
                if (aString.length() > 0 && aString.charAt(i) == '+') {
                    nextMode = MATH_OP.PLUS;
                } else if (aString.length() > 0 && aString.charAt(i) == '-') {
                    nextMode = MATH_OP.MINUS;
                } else if (aString.length() > 0 && aString.charAt(i) == '*') {
                    nextMode = MATH_OP.MULTIPLY;
                } else if (aString.length() > 0 && aString.charAt(i) == '/') {
                    nextMode = MATH_OP.DIVIDE;
                }
            }
            if (valString.length() > 0) {
                float valFloat = 0.0f;
                try {
                    valFloat = Float.parseFloat(valString);
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
                switch (mode) {
                    case PLUS: {
                        total = Float.valueOf(total.floatValue() + valFloat);
                        break;
                    }
                    case MINUS: {
                        total = Float.valueOf(total.floatValue() - valFloat);
                        break;
                    }
                    case MULTIPLY: {
                        total = Float.valueOf(total.floatValue() * valFloat);
                        break;
                    }
                    case DIVIDE: {
                        total = Float.valueOf(total.floatValue() / valFloat);
                        break;
                    }
                    default: {
                        Logging.errorPrint("In PlayerCharacter.getVariableValue the mode " + (Object)((Object)mode) + " is unsupported.");
                    }
                }
            }
            mode = nextMode;
            nextMode = MATH_OP.PLUS;
            valString = "";
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private CachableResult processJepFormula(CharacterSpell spell, String formula, String src) {
        String DEBUG_FORMULA_PREFIX = "CLASSLEVEL";
        if (Logging.isLoggable(Logging.DEBUG) && formula.startsWith("CLASSLEVEL")) {
            Logging.debugPrint(this.jepIndent + "getJepVariable: " + formula);
        }
        this.jepIndent = this.jepIndent + "    ";
        PJEP parser = null;
        try {
            parser = PjepPool.getInstance().aquire(this, src);
            parser.parseExpression(formula);
            if (parser.hasError()) {
                if (Logging.isLoggable(Logging.DEBUG) && formula.startsWith("CLASSLEVEL")) {
                    Logging.debugPrint(this.jepIndent + "not a JEP expression: " + formula);
                }
                CachableResult cachableResult = null;
                return cachableResult;
            }
            for (Object element : parser.getSymbolTable().keySet()) {
                if ("e".equals(element) || "FALSE".equals(element) || "pi".equals(element) || "TRUE".equals(element)) continue;
                Float d = this.lookupVariable((String)element, src, spell);
                if (d == null) {
                    CachableResult cachableResult = null;
                    return cachableResult;
                }
                parser.addVariable((String)element, d.doubleValue());
            }
            Object result = parser.getValueAsObject();
            if (result != null) {
                if (Logging.isLoggable(Logging.DEBUG) && formula.startsWith("CLASSLEVEL")) {
                    Logging.debugPrint(this.jepIndent + "Result '" + formula + "' = " + result);
                }
                try {
                    Object element;
                    element = new CachableResult(new Float(result.toString()), parser.isResultCachable());
                    return element;
                }
                catch (NumberFormatException nfe) {
                    if (Logging.isLoggable(Logging.DEBUG) && formula.startsWith("CLASSLEVEL")) {
                        Logging.debugPrint(this.jepIndent + "Result '" + formula + "' = " + result + " was not a number...");
                    }
                    CachableResult cachableResult = null;
                    if (this.jepIndent != null && this.jepIndent.length() >= 4) {
                        this.jepIndent = this.jepIndent.substring(4);
                    }
                    PjepPool.getInstance().release(parser);
                    return cachableResult;
                }
            }
            if (parser.hasError()) {
                Logging.errorPrint("Failed to process formala " + formula + " due to error: " + parser.getErrorInfo());
            }
            if (Logging.isLoggable(Logging.DEBUG) && formula.startsWith("CLASSLEVEL")) {
                Logging.debugPrint(this.jepIndent + "Result '" + formula + "' was null...");
            }
            CachableResult cachableResult = null;
            return cachableResult;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (this.jepIndent != null && this.jepIndent.length() >= 4) {
                this.jepIndent = this.jepIndent.substring(4);
            }
            PjepPool.getInstance().release(parser);
        }
    }

    abstract Float getInternalVariable(CharacterSpell var1, String var2, String var3);

    public Float lookupVariable(String term, String src, CharacterSpell spell) {
        String evReturn;
        Float retVal = null;
        if (this.pc.hasVariable(term)) {
            Float value = this.pc.getVariable(term, true);
            if (Logging.isDebugMode()) {
                Logging.debugPrint(this.jepIndent + "variable for: '" + term + "' = " + value);
            }
            retVal = new Float(value.doubleValue());
        }
        if (retVal == null) {
            retVal = this.getInternalVariable(spell, term, src);
        }
        if (retVal == null && (evReturn = this.getExportVariable(term)) != null) {
            retVal = this.convertToFloat(term, evReturn);
        }
        return retVal;
    }

    public Float getCachedVariable(String lookup) {
        if (this.isCachePaused()) {
            return null;
        }
        CachedVariable<Float> cached = this.fVariableCache.get(lookup);
        if (cached != null) {
            if (cached.getSerial() >= this.getSerial()) {
                return cached.getValue();
            }
            this.fVariableCache.remove(lookup);
        }
        return null;
    }

    public void addCachedVariable(String lookup, Float value) {
        if (this.isCachePaused()) {
            return;
        }
        CachedVariable<Float> cached = new CachedVariable<Float>();
        cached.setSerial(this.getSerial());
        cached.setValue(value);
        this.fVariableCache.put(lookup, cached);
    }

    public void restartCache() {
        this.serial = this.cachePaused;
        this.cachePaused = 0;
    }

    public void pauseCache() {
        this.cachePaused = this.serial;
    }

    public boolean isCachePaused() {
        return this.cachePaused > 0;
    }

    public int getSerial() {
        return this.serial;
    }

    public void setSerial(int serial) {
        this.serial = serial;
    }

    String getCachedString(String lookup) {
        if (this.isCachePaused()) {
            return null;
        }
        CachedVariable<String> cached = this.sVariableCache.get(lookup);
        if (cached != null) {
            if (cached.getSerial() >= this.getSerial()) {
                return cached.getValue();
            }
            this.sVariableCache.remove(lookup);
        }
        return null;
    }

    public void addCachedString(String lookup, String value) {
        if (this.isCachePaused()) {
            return;
        }
        CachedVariable<String> cached = new CachedVariable<String>();
        cached.setSerial(this.getSerial());
        cached.setValue(value);
        this.sVariableCache.put(lookup, cached);
    }

    public String getExportVariable(String valString) {
        String result;
        StringWriter sWriter = new StringWriter();
        BufferedWriter aWriter = new BufferedWriter(sWriter);
        ExportHandler aExport = new ExportHandler(new File(""));
        aExport.replaceTokenSkipMath(this.pc, valString, aWriter);
        sWriter.flush();
        try {
            aWriter.flush();
        }
        catch (IOException e) {
            Logging.errorPrint("Couldn't flush the StringWriter used in PlayerCharacter.getVariableValue.", e);
        }
        String bString = sWriter.toString();
        try {
            result = String.valueOf(Float.parseFloat(bString));
        }
        catch (NumberFormatException e) {
            result = bString;
        }
        return result;
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    private static class CachableResult {
        final Float result;
        final boolean cachable;

        CachableResult(Float result, boolean cachable) {
            this.result = result;
            this.cachable = cachable;
        }
    }

    private static enum MATH_OP {
        PLUS,
        MINUS,
        MULTIPLY,
        DIVIDE;

    }
}

