/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.display;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import pcgen.cdom.content.DamageReduction;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.DamageReductionFacet;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.base.AbstractListFacet;
import pcgen.cdom.facet.model.StatFacet;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.BonusCalc;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.display.NonAbilityDisplay;

public class TemplateModifier {
    private static DamageReductionFacet drFacet = FacetLibrary.getFacet(DamageReductionFacet.class);
    private static StatFacet statFacet = FacetLibrary.getFacet(StatFacet.class);

    public static String modifierString(PCTemplate pct, PlayerCharacter aPC) {
        float cr;
        int nat;
        StringBuilder mods = new StringBuilder(50);
        CharID id = aPC.getCharID();
        for (PCStat stat : ((AbstractListFacet)statFacet).getSet(id)) {
            if (NonAbilityDisplay.isNonAbilityForObject(stat, pct)) {
                mods.append(stat.getKeyName()).append(":nonability ");
                continue;
            }
            int statMod = BonusCalc.getStatMod(pct, stat, aPC);
            if (statMod == 0) continue;
            mods.append(stat.getKeyName()).append(':').append(statMod).append(' ');
        }
        IdentityHashMap<DamageReduction, Set<Object>> drMap = new IdentityHashMap<DamageReduction, Set<Object>>();
        CharacterDisplay display = aPC.getDisplay();
        int totalLevels = display.getTotalLevels();
        int totalHitDice = display.totalHitDice();
        ArrayList<PCTemplate> templList = new ArrayList<PCTemplate>();
        templList.add(pct);
        templList.addAll(pct.getConditionalTemplates(totalLevels, totalHitDice));
        for (PCTemplate subt : templList) {
            List<DamageReduction> tList = subt.getListFor(ListKey.DAMAGE_REDUCTION);
            if (tList == null) continue;
            for (DamageReduction dr : tList) {
                HashSet<PCTemplate> set = (HashSet<PCTemplate>)drMap.get(dr);
                if (set == null) {
                    set = new HashSet<PCTemplate>();
                    drMap.put(dr, set);
                }
                set.add(pct);
            }
        }
        if (drMap.size() != 0) {
            mods.append("DR:").append(drFacet.getDRString(id, drMap));
        }
        if ((nat = (int)BonusCalc.charBonusTo(pct, "COMBAT", "AC", aPC)) != 0) {
            mods.append("AC BONUS:").append(nat);
        }
        if ((cr = (float)pct.getCR(totalLevels, totalHitDice).intValue()) != 0.0f) {
            mods.append("CR:").append(cr).append(' ');
        }
        if (display.getTemplateSR(pct, totalLevels, totalHitDice) != 0) {
            mods.append("SR:").append(display.getTemplateSR(pct, totalLevels, totalHitDice)).append(' ');
        }
        return mods.toString();
    }
}

