/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.prefs;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pcgen.cdom.content.RollMethod;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.core.GameMode;
import pcgen.core.PointBuyMethod;
import pcgen.core.SettingsHandler;
import pcgen.gui2.prefs.PCGenPrefsPanel;
import pcgen.gui2.prefs.PurchaseModeFrame;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.JComboBoxEx;
import pcgen.system.LanguageBundle;

public class CharacterStatsPanel
extends PCGenPrefsPanel {
    private static String in_abilities = LanguageBundle.getString("in_Prefs_abilities");
    private String[] pMode;
    private String[] pModeMethodName;
    private JDialog parent;
    private JRadioButton abilitiesAllSameButton;
    private JRadioButton abilitiesPurchasedButton;
    private JRadioButton abilitiesRolledButton;
    private JRadioButton abilitiesUserRolledButton;
    private JComboBoxEx abilityPurchaseModeCombo;
    private JComboBoxEx abilityRolledModeCombo = null;
    private JComboBoxEx abilityScoreCombo;
    private JButton purchaseModeButton;
    private PurchaseModeFrame pmsFrame = null;
    private ActionListener rolledModeListener;
    private ActionListener purchaseModeListener;
    private ActionListener scoreListener;

    public CharacterStatsPanel(JDialog parent) {
        this.parent = parent;
        this.initComponents();
        this.addAbilitiesPanelListeners();
    }

    private void initComponents() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Border etched = null;
        TitledBorder title1 = BorderFactory.createTitledBorder(etched, in_abilities);
        title1.setTitleJustification(1);
        this.setBorder(title1);
        this.setLayout(gridbag);
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(2, 2, 2, 2);
        GameMode gameMode = SettingsHandler.getGame();
        int row = 0;
        ButtonGroup exclusiveGroup = new ButtonGroup();
        Utility.buildConstraints(c, 0, row++, 3, 1, 0.0, 0.0);
        JLabel label = new JLabel(LanguageBundle.getFormattedString("in_Prefs_abilitiesGenLabel", gameMode.getDisplayName()));
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 0, row, 1, 1, 0.0, 0.0);
        label = new JLabel("  ");
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 1, row++, 2, 1, 0.0, 0.0);
        this.abilitiesUserRolledButton = new JRadioButton(LanguageBundle.getString("in_Prefs_abilitiesUserRolled"));
        gridbag.setConstraints(this.abilitiesUserRolledButton, c);
        this.add(this.abilitiesUserRolledButton);
        exclusiveGroup.add(this.abilitiesUserRolledButton);
        Utility.buildConstraints(c, 1, row++, 2, 1, 0.0, 0.0);
        this.abilitiesAllSameButton = new JRadioButton(LanguageBundle.getString("in_Prefs_abilitiesAllSame") + ": ");
        gridbag.setConstraints(this.abilitiesAllSameButton, c);
        this.add(this.abilitiesAllSameButton);
        exclusiveGroup.add(this.abilitiesAllSameButton);
        Utility.buildConstraints(c, 1, row, 1, 1, 0.0, 0.0);
        label = new JLabel("  ");
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 2, row++, 2, 1, 0.0, 0.0);
        this.abilityScoreCombo = new JComboBoxEx();
        for (int i = gameMode.getStatMin(); i <= gameMode.getStatMax(); ++i) {
            this.abilityScoreCombo.addItem(String.valueOf(i));
        }
        gridbag.setConstraints(this.abilityScoreCombo, c);
        this.add(this.abilityScoreCombo);
        ReferenceManufacturer<RollMethod> mfg = gameMode.getModeContext().getReferenceContext().getManufacturer(RollMethod.class);
        List<RollMethod> rollMethods = mfg.getOrderSortedObjects();
        if (!rollMethods.isEmpty()) {
            Utility.buildConstraints(c, 1, row++, 2, 1, 0.0, 0.0);
            this.abilitiesRolledButton = new JRadioButton("Rolled:");
            gridbag.setConstraints(this.abilitiesRolledButton, c);
            this.add(this.abilitiesRolledButton);
            exclusiveGroup.add(this.abilitiesRolledButton);
            Utility.buildConstraints(c, 2, row++, 2, 1, 0.0, 0.0);
            this.abilityRolledModeCombo = new JComboBoxEx();
            for (RollMethod rm : rollMethods) {
                this.abilityRolledModeCombo.addItem(rm.getDisplayName());
            }
            gridbag.setConstraints(this.abilityRolledModeCombo, c);
            this.add(this.abilityRolledModeCombo);
        }
        Collection<PointBuyMethod> methods = SettingsHandler.getGame().getModeContext().getReferenceContext().getConstructedCDOMObjects(PointBuyMethod.class);
        int purchaseMethodCount = methods.size();
        Utility.buildConstraints(c, 1, row++, 2, 1, 0.0, 0.0);
        this.abilitiesPurchasedButton = new JRadioButton(LanguageBundle.getString("in_Prefs_abilitiesPurchased") + ": ");
        gridbag.setConstraints(this.abilitiesPurchasedButton, c);
        this.add(this.abilitiesPurchasedButton);
        exclusiveGroup.add(this.abilitiesPurchasedButton);
        Utility.buildConstraints(c, 2, row++, 2, 1, 0.0, 0.0);
        this.pMode = new String[purchaseMethodCount];
        this.pModeMethodName = new String[purchaseMethodCount];
        int i = 0;
        for (PointBuyMethod pbm : methods) {
            this.pMode[i] = pbm.getDescription();
            this.pModeMethodName[i] = pbm.getDisplayName();
            ++i;
        }
        this.abilityPurchaseModeCombo = new JComboBoxEx(this.pMode);
        gridbag.setConstraints(this.abilityPurchaseModeCombo, c);
        this.add(this.abilityPurchaseModeCombo);
        if (purchaseMethodCount == 0) {
            this.abilityPurchaseModeCombo.setVisible(false);
            this.abilitiesPurchasedButton.setVisible(false);
        }
        Utility.buildConstraints(c, 1, row++, 1, 1, 0.0, 0.0);
        label = new JLabel(" ");
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 1, row++, 3, 1, 0.0, 0.0);
        this.purchaseModeButton = new JButton(LanguageBundle.getString("in_Prefs_purchaseModeConfig"));
        gridbag.setConstraints(this.purchaseModeButton, c);
        this.add(this.purchaseModeButton);
        this.purchaseModeButton.addActionListener(new PurchaseModeButtonListener());
        Utility.buildConstraints(c, 5, 20, 1, 1, 1.0, 1.0);
        c.fill = 1;
        label = new JLabel(" ");
        gridbag.setConstraints(label, c);
        this.add(label);
    }

    @Override
    public void applyOptionValuesToControls() {
        this.stopListeners();
        GameMode gameMode = SettingsHandler.getGame();
        boolean bValid = true;
        int rollMethod = gameMode.getRollMethod();
        switch (rollMethod) {
            case 0: {
                this.abilitiesUserRolledButton.setSelected(true);
                break;
            }
            case 1: {
                this.abilitiesAllSameButton.setSelected(true);
                break;
            }
            case 2: {
                if (!this.abilitiesPurchasedButton.isVisible() || this.pMode.length == 0) {
                    bValid = false;
                    break;
                }
                this.abilitiesPurchasedButton.setSelected(true);
                break;
            }
            case 3: {
                if (this.abilitiesRolledButton == null) {
                    bValid = false;
                    break;
                }
                this.abilitiesRolledButton.setSelected(true);
                this.abilityRolledModeCombo.setSelectedItem(gameMode.getRollMethodExpressionName());
                break;
            }
            default: {
                bValid = false;
            }
        }
        if (!bValid) {
            this.abilitiesUserRolledButton.setSelected(true);
            gameMode.setRollMethod(0);
        }
        int allStatsValue = Math.min(gameMode.getStatMax(), gameMode.getAllStatsValue());
        allStatsValue = Math.max(gameMode.getStatMin(), allStatsValue);
        gameMode.setAllStatsValue(allStatsValue);
        this.abilityScoreCombo.setSelectedIndex(allStatsValue - gameMode.getStatMin());
        if (this.pMode != null && this.pModeMethodName != null) {
            String methodName = gameMode.getPurchaseModeMethodName();
            for (int i = 0; i < this.pMode.length; ++i) {
                if (!this.pModeMethodName[i].equals(methodName)) continue;
                this.abilityPurchaseModeCombo.setSelectedIndex(i);
            }
        }
        this.startListeners();
    }

    private void showPurchaseModeConfiguration() {
        if (this.pmsFrame == null) {
            this.pmsFrame = new PurchaseModeFrame(this.parent);
            GameMode gameMode = SettingsHandler.getGame();
            this.pmsFrame.setStatMin(gameMode.getStatMin());
            this.pmsFrame.setStatMax(gameMode.getStatMax());
            this.pmsFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    Collection<PointBuyMethod> methods = SettingsHandler.getGame().getModeContext().getReferenceContext().getConstructedCDOMObjects(PointBuyMethod.class);
                    int purchaseMethodCount = methods.size();
                    CharacterStatsPanel.access$102(CharacterStatsPanel.this, new String[purchaseMethodCount]);
                    CharacterStatsPanel.access$202(CharacterStatsPanel.this, new String[purchaseMethodCount]);
                    String methodName = SettingsHandler.getGame().getPurchaseModeMethodName();
                    CharacterStatsPanel.this.abilityPurchaseModeCombo.removeAllItems();
                    int i = 0;
                    for (PointBuyMethod pbm : methods) {
                        ((CharacterStatsPanel)CharacterStatsPanel.this).pMode[i] = pbm.getDescription();
                        ((CharacterStatsPanel)CharacterStatsPanel.this).pModeMethodName[i] = pbm.getDisplayName();
                        CharacterStatsPanel.this.abilityPurchaseModeCombo.addItem(CharacterStatsPanel.this.pMode[i]);
                        if (CharacterStatsPanel.this.pModeMethodName[i].equals(methodName)) {
                            CharacterStatsPanel.this.abilityPurchaseModeCombo.setSelectedIndex(i);
                        }
                        ++i;
                    }
                    CharacterStatsPanel.this.pmsFrame = null;
                    CharacterStatsPanel.this.abilityPurchaseModeCombo.setVisible(purchaseMethodCount != 0);
                    CharacterStatsPanel.this.abilitiesPurchasedButton.setVisible(purchaseMethodCount != 0);
                    if (!CharacterStatsPanel.this.abilitiesPurchasedButton.isVisible() && CharacterStatsPanel.this.abilitiesPurchasedButton.isSelected()) {
                        CharacterStatsPanel.this.abilitiesUserRolledButton.setSelected(true);
                    }
                }
            });
        }
        Utility.centerDialog(this.pmsFrame);
        this.pmsFrame.setVisible(true);
    }

    private void addAbilitiesPanelListeners() {
        this.scoreListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharacterStatsPanel.this.abilitiesAllSameButton.setSelected(true);
            }
        };
        this.purchaseModeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharacterStatsPanel.this.abilitiesPurchasedButton.setSelected(true);
            }
        };
        this.rolledModeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharacterStatsPanel.this.abilitiesRolledButton.setSelected(true);
            }
        };
        this.startListeners();
    }

    private void startListeners() {
        this.abilityScoreCombo.addActionListener(this.scoreListener);
        this.abilityPurchaseModeCombo.addActionListener(this.purchaseModeListener);
        if (this.abilityRolledModeCombo != null) {
            this.abilityRolledModeCombo.addActionListener(this.rolledModeListener);
        }
    }

    private void stopListeners() {
        this.abilityScoreCombo.removeActionListener(this.scoreListener);
        this.abilityPurchaseModeCombo.removeActionListener(this.purchaseModeListener);
        if (this.abilityRolledModeCombo != null) {
            this.abilityRolledModeCombo.removeActionListener(this.rolledModeListener);
        }
    }

    @Override
    public String getTitle() {
        return in_abilities;
    }

    @Override
    public void setOptionsBasedOnControls() {
        GameMode gameMode = SettingsHandler.getGame();
        gameMode.setAllStatsValue(this.abilityScoreCombo.getSelectedIndex() + gameMode.getStatMin());
        if (this.abilitiesUserRolledButton.isSelected()) {
            gameMode.setRollMethod(0);
        } else if (this.abilitiesAllSameButton.isSelected()) {
            gameMode.setRollMethod(1);
        } else if (this.abilitiesPurchasedButton.isSelected()) {
            if (this.abilityPurchaseModeCombo.isVisible() && this.abilityPurchaseModeCombo.getSelectedIndex() >= 0) {
                gameMode.setPurchaseMethodName(this.pModeMethodName[this.abilityPurchaseModeCombo.getSelectedIndex()]);
            } else {
                gameMode.setRollMethod(0);
            }
        } else if (this.abilitiesRolledButton != null && this.abilitiesRolledButton.isSelected()) {
            if (this.abilityRolledModeCombo.getSelectedIndex() >= 0) {
                gameMode.setRollMethodExpressionByName(this.abilityRolledModeCombo.getSelectedItem().toString());
            } else {
                gameMode.setRollMethod(0);
            }
        }
    }

    public void setParent(JDialog parent) {
        this.parent = parent;
    }

    static /* synthetic */ String[] access$102(CharacterStatsPanel x0, String[] x1) {
        x0.pMode = x1;
        return x1;
    }

    static /* synthetic */ String[] access$202(CharacterStatsPanel x0, String[] x1) {
        x0.pModeMethodName = x1;
        return x1;
    }

    private final class PurchaseModeButtonListener
    implements ActionListener {
        private PurchaseModeButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CharacterStatsPanel.this.showPurchaseModeConfiguration();
        }
    }
}

