/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.summary;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.LanguageChooserFacade;
import pcgen.facade.core.LanguageFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.dialog.LanguageChooserDialog;
import pcgen.gui2.tabs.Utilities;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.SignIcon;
import pcgen.gui2.util.table.TableCellUtilities;
import pcgen.system.LanguageBundle;

public class LanguageTableModel
extends AbstractTableModel
implements ListListener<LanguageFacade> {
    private ListFacade<LanguageFacade> languages;
    private ListFacade<LanguageChooserFacade> choosers;
    private CharacterFacade character;
    private JTable table;
    private int dirtyRow = -1;
    private MouseListener mouseListener = new MouseListener();
    private Renderer renderer = new Renderer();
    private Editor editor = new Editor();

    public LanguageTableModel(CharacterFacade character, JTable table) {
        this.table = table;
        this.character = character;
        this.languages = character.getLanguages();
        this.choosers = character.getLanguageChoosers();
        this.languages.addListListener(this);
    }

    public static void initializeTable(JTable table) {
        table.setCellSelectionEnabled(false);
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.setFocusable(false);
        table.setRowHeight(21);
        table.getTableHeader().setReorderingAllowed(false);
    }

    public void install() {
        this.table.addMouseListener(this.mouseListener);
        this.table.addMouseMotionListener(this.mouseListener);
        this.table.setModel(this);
        this.table.setDefaultRenderer(Object.class, this.renderer);
        this.table.setDefaultEditor(Object.class, this.editor);
    }

    public void uninstall() {
        this.table.removeMouseListener(this.mouseListener);
        this.table.removeMouseMotionListener(this.mouseListener);
        this.dirtyRow = -1;
    }

    @Override
    public int getRowCount() {
        return this.languages.getSize() + this.choosers.getSize();
    }

    @Override
    public String getColumnName(int column) {
        return LanguageBundle.getString("in_sumLanguages");
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.languages.getSize()) {
            return this.languages.getElementAt(rowIndex);
        }
        return this.choosers.getElementAt(rowIndex - this.languages.getSize());
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return rowIndex >= this.languages.getSize() || this.character.isRemovable(this.languages.getElementAt(rowIndex));
    }

    @Override
    public void elementAdded(ListEvent<LanguageFacade> e) {
        this.fireTableRowsInserted(e.getIndex(), e.getIndex());
        this.editor.cancelCellEditing();
    }

    @Override
    public void elementRemoved(ListEvent<LanguageFacade> e) {
        this.fireTableRowsDeleted(e.getIndex(), e.getIndex());
        this.editor.cancelCellEditing();
    }

    @Override
    public void elementsChanged(ListEvent<LanguageFacade> e) {
        this.fireTableDataChanged();
        this.editor.cancelCellEditing();
    }

    @Override
    public void elementModified(ListEvent<LanguageFacade> e) {
        this.fireTableRowsUpdated(e.getIndex(), e.getIndex());
    }

    private class Renderer
    extends JPanel
    implements TableCellRenderer {
        private final String ADD_ID = "Add";
        private final String REMOVE_ID = "Remove";
        private CardLayout cardLayout = new CardLayout();
        private JLabel cellLabel = new JLabel();
        private JButton addButton = Utilities.createSignButton(SignIcon.Sign.Plus);
        private JButton removeButton = Utilities.createSignButton(SignIcon.Sign.Minus);
        private JLabel addLabel = new JLabel();

        public Renderer() {
            this.setLayout(this.cardLayout);
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalStrut(3));
            box.add(this.cellLabel);
            box.add(Box.createHorizontalGlue());
            box.add(this.removeButton);
            box.add(Box.createHorizontalStrut(2));
            this.add((Component)box, "Remove");
            box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            box.add(this.addLabel);
            box.add(Box.createHorizontalStrut(3));
            box.add(this.addButton);
            box.add(Box.createHorizontalStrut(2));
            this.add((Component)box, "Add");
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableCellUtilities.setToRowBackground(this, jTable, row);
            if (row < LanguageTableModel.this.languages.getSize()) {
                boolean removable;
                boolean automatic = value instanceof LanguageFacade && LanguageTableModel.this.character.isAutomatic((LanguageFacade)value);
                boolean bl = removable = value instanceof LanguageFacade && LanguageTableModel.this.character.isRemovable((LanguageFacade)value);
                if (automatic) {
                    this.cellLabel.setForeground(UIPropertyContext.getAutomaticColor());
                } else {
                    this.cellLabel.setForeground(jTable.getForeground());
                }
                this.cellLabel.setText(value.toString());
                this.cellLabel.setFont(jTable.getFont());
                this.removeButton.setEnabled(LanguageTableModel.this.dirtyRow == row);
                this.removeButton.setVisible(removable);
                this.cardLayout.show(this, "Remove");
            } else {
                this.addLabel.setText(((LanguageChooserFacade)value).getName());
                this.addLabel.setFont(jTable.getFont());
                this.addLabel.setForeground(jTable.getForeground());
                this.cardLayout.show(this, "Add");
            }
            return this;
        }
    }

    private class Editor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private final String ADD_ID = "Add";
        private final String REMOVE_ID = "Remove";
        private JPanel cellPanel = new JPanel();
        private CardLayout cardLayout = new CardLayout();
        private JLabel addLabel = new JLabel();
        private JLabel cellLabel = new JLabel();

        public Editor() {
            this.cellPanel.setLayout(this.cardLayout);
            this.cellPanel.setOpaque(true);
            JButton addButton = Utilities.createSignButton(SignIcon.Sign.Plus);
            JButton removeButton = Utilities.createSignButton(SignIcon.Sign.Minus);
            addButton.setActionCommand("Add");
            removeButton.setActionCommand("Remove");
            addButton.setFocusable(false);
            removeButton.setFocusable(false);
            addButton.addActionListener(this);
            removeButton.addActionListener(this);
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            box.add(this.addLabel);
            box.add(Box.createHorizontalStrut(3));
            box.add(addButton);
            box.add(Box.createHorizontalStrut(2));
            this.cellPanel.add((Component)box, "Add");
            box = Box.createHorizontalBox();
            box.add(Box.createHorizontalStrut(3));
            box.add(this.cellLabel);
            box.add(Box.createHorizontalGlue());
            box.add(removeButton);
            box.add(Box.createHorizontalStrut(2));
            this.cellPanel.add((Component)box, "Remove");
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object value, boolean isSelected, int row, int column) {
            TableCellUtilities.setToRowBackground(this.cellPanel, jTable, row);
            if (row >= LanguageTableModel.this.languages.getSize()) {
                this.addLabel.setForeground(jTable.getForeground());
                this.addLabel.setFont(jTable.getFont());
                this.addLabel.setText(((LanguageChooserFacade)value).getName());
                this.cardLayout.show(this.cellPanel, "Add");
            } else {
                this.cellLabel.setForeground(jTable.getForeground());
                this.cellLabel.setFont(jTable.getFont());
                this.cellLabel.setText(value.toString());
                this.cardLayout.show(this.cellPanel, "Remove");
            }
            return this.cellPanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ("Add".equals(e.getActionCommand())) {
                Frame frame = JOptionPane.getFrameForComponent(LanguageTableModel.this.table);
                LanguageChooserFacade chooser = (LanguageChooserFacade)LanguageTableModel.this.choosers.getElementAt(LanguageTableModel.this.table.getEditingRow() - LanguageTableModel.this.languages.getSize());
                LanguageChooserDialog dialog = new LanguageChooserDialog(frame, chooser);
                Utility.setDialogRelativeLocation(frame, dialog);
                dialog.setVisible(true);
            } else {
                LanguageFacade lang = (LanguageFacade)LanguageTableModel.this.getValueAt(LanguageTableModel.this.table.getEditingRow(), 0);
                LanguageTableModel.this.character.removeLanguage(lang);
            }
            this.cancelCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            LanguageTableModel.this.table.repaint(LanguageTableModel.this.table.getCellRect(LanguageTableModel.this.dirtyRow, 0, true));
            LanguageTableModel.this.dirtyRow = -1;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int row = LanguageTableModel.this.table.rowAtPoint(e.getPoint());
            if (row != LanguageTableModel.this.dirtyRow) {
                LanguageTableModel.this.editor.cancelCellEditing();
                LanguageTableModel.this.table.repaint(LanguageTableModel.this.table.getCellRect(LanguageTableModel.this.dirtyRow, 0, true));
                LanguageTableModel.this.dirtyRow = row;
                LanguageTableModel.this.table.repaint(LanguageTableModel.this.table.getCellRect(LanguageTableModel.this.dirtyRow, 0, true));
            }
        }
    }
}

