/*
 * Decompiled with CFR 0.152.
 */
package pcgen.output.wrapper;

import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModelException;
import java.util.HashMap;
import java.util.Map;
import pcgen.cdom.base.CDOMObject;
import pcgen.core.Ability;
import pcgen.core.ArmorProf;
import pcgen.core.Campaign;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Kit;
import pcgen.core.Language;
import pcgen.core.PCAlignment;
import pcgen.core.PCCheck;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.Race;
import pcgen.core.ShieldProf;
import pcgen.core.SizeAdjustment;
import pcgen.core.WeaponProf;
import pcgen.output.actor.KeyActor;
import pcgen.output.actor.OutputNameActor;
import pcgen.output.actor.SourceActor;
import pcgen.output.base.OutputActor;
import pcgen.output.model.CDOMObjectModel;
import pcgen.output.model.CDOMObjectWrapperInfo;

public final class CDOMObjectWrapper
implements ObjectWrapper {
    private static final CDOMObjectWrapper INSTANCE = new CDOMObjectWrapper();
    private final Map<Class<?>, CDOMObjectWrapperInfo> infoMap = new HashMap();

    private CDOMObjectWrapper() {
    }

    public <T extends CDOMObject> boolean load(Class<T> cl, String name, OutputActor<CDOMObject> oa) {
        return this.getWrapperInfo(cl).load(name, oa);
    }

    private <T> CDOMObjectWrapperInfo getWrapperInfo(Class<T> cl) {
        if (cl == null) {
            return null;
        }
        CDOMObjectWrapperInfo info = this.infoMap.get(cl);
        if (info == null) {
            Class<T> superclass = cl.getSuperclass();
            info = new CDOMObjectWrapperInfo(this.getWrapperInfo(superclass));
            this.infoMap.put(cl, info);
        }
        return info;
    }

    public TemplateHashModel wrap(Object o) throws TemplateModelException {
        if (o instanceof CDOMObject) {
            CDOMObject cdo = (CDOMObject)o;
            Class<?> cl = cdo.getClass();
            CDOMObjectWrapperInfo info = this.getWrapperInfo(cl);
            return new CDOMObjectModel(info, cdo);
        }
        throw new TemplateModelException("Object was not a CDOMObject");
    }

    public static CDOMObjectWrapper getInstance() {
        return INSTANCE;
    }

    public void clear() {
        this.infoMap.clear();
        CDOMObjectWrapper.triggerLoad();
    }

    private static void triggerLoad() {
        INSTANCE.load(CDOMObject.class, "source", new SourceActor());
        INSTANCE.load(CDOMObject.class, "key", new KeyActor());
        INSTANCE.load(Ability.class, "outputname", new OutputNameActor());
        INSTANCE.load(ArmorProf.class, "outputname", new OutputNameActor());
        INSTANCE.load(Campaign.class, "outputname", new OutputNameActor());
        INSTANCE.load(Deity.class, "outputname", new OutputNameActor());
        INSTANCE.load(Domain.class, "outputname", new OutputNameActor());
        INSTANCE.load(Equipment.class, "outputname", new OutputNameActor());
        INSTANCE.load(Kit.class, "outputname", new OutputNameActor());
        INSTANCE.load(Language.class, "outputname", new OutputNameActor());
        INSTANCE.load(PCAlignment.class, "outputname", new OutputNameActor());
        INSTANCE.load(PCCheck.class, "outputname", new OutputNameActor());
        INSTANCE.load(PCClass.class, "outputname", new OutputNameActor());
        INSTANCE.load(PCStat.class, "outputname", new OutputNameActor());
        INSTANCE.load(PCTemplate.class, "outputname", new OutputNameActor());
        INSTANCE.load(Race.class, "outputname", new OutputNameActor());
        INSTANCE.load(ShieldProf.class, "outputname", new OutputNameActor());
        INSTANCE.load(SizeAdjustment.class, "outputname", new OutputNameActor());
        INSTANCE.load(WeaponProf.class, "outputname", new OutputNameActor());
    }

    static {
        CDOMObjectWrapper.triggerLoad();
    }
}

