/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.gamemode.tab;

import pcgen.cdom.content.TabInfo;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class VisibleToken
extends AbstractNonEmptyToken<TabInfo>
implements CDOMPrimaryToken<TabInfo> {
    @Override
    public String getTokenName() {
        return "VISIBLE";
    }

    @Override
    public ParseResult parseNonEmptyToken(LoadContext context, TabInfo ti, String value) {
        boolean set;
        char firstChar = value.charAt(0);
        if (firstChar == 'y' || firstChar == 'Y') {
            if (value.length() > 1 && !value.equalsIgnoreCase("YES")) {
                return new ParseResult.Fail("You should use 'YES' as the " + this.getTokenName() + ": " + value, context);
            }
            set = Boolean.TRUE;
        } else {
            if (firstChar != 'N' && firstChar != 'n') {
                return new ParseResult.Fail("You should use 'YES' or 'NO' as the " + this.getTokenName() + ": " + value, context);
            }
            if (value.length() > 1 && !value.equalsIgnoreCase("NO")) {
                return new ParseResult.Fail("You should use 'YES' or 'NO' as the " + this.getTokenName() + ": " + value, context);
            }
            set = Boolean.FALSE;
        }
        ti.setVisible(set);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, TabInfo ti) {
        if (ti.isVisible()) {
            return null;
        }
        return new String[]{"NO"};
    }

    @Override
    public Class<TabInfo> getTokenClass() {
        return TabInfo.class;
    }
}

