/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Deity;
import pcgen.core.PCClass;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class DeityToken
extends AbstractTokenWithSeparator<PCClass>
implements CDOMPrimaryToken<PCClass> {
    private static final Class<Deity> DEITY_CLASS = Deity.class;

    @Override
    public String getTokenName() {
        return "DEITY";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClass pcc, String value) {
        context.getObjectContext().removeList(pcc, ListKey.DEITY);
        StringTokenizer tok = new StringTokenizer(value, "|");
        while (tok.hasMoreTokens()) {
            String tokText = tok.nextToken();
            CDOMSingleRef<Deity> deity = context.getReferenceContext().getCDOMReference(DEITY_CLASS, tokText);
            context.getObjectContext().addToList(pcc, ListKey.DEITY, deity);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, PCClass pcc) {
        Changes<CDOMReference<Deity>> changes = context.getObjectContext().getListChanges(pcc, ListKey.DEITY);
        Collection<CDOMReference<Deity>> added = changes.getAdded();
        if (added == null || added.isEmpty()) {
            return null;
        }
        return new String[]{ReferenceUtilities.joinLstFormat(added, "|")};
    }

    @Override
    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

