/*
 * Decompiled with CFR 0.152.
 */
package plugin.dicebag.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import plugin.dicebag.gui.DiceBagMessage;
import plugin.dicebag.gui.DiceBagModel;

public class DiceBagPluginModel
extends Observable {
    private DiceBagModel m_activeBag;
    private List<DiceBagModel> m_diceBags = new ArrayList<DiceBagModel>();

    public void setActiveBag(DiceBagModel model) {
        this.m_activeBag = model;
    }

    public DiceBagModel getActiveBag() {
        return this.m_activeBag;
    }

    public void addNewDicebag() {
        DiceBagModel bag = new DiceBagModel();
        this.m_diceBags.add(bag);
        this.setChanged();
        this.notifyObservers(new DiceBagMessage(2, bag));
    }

    public void closeDiceBag(DiceBagModel bag) {
        this.m_diceBags.remove(bag);
        this.setChanged();
        this.notifyObservers(new DiceBagMessage(4, bag));
    }

    public boolean loadDiceBag(File f) {
        boolean returnValue = false;
        DiceBagModel bag = new DiceBagModel(f);
        returnValue = this.m_diceBags.add(bag);
        this.setChanged();
        this.notifyObservers(new DiceBagMessage(2, bag));
        return returnValue;
    }

    public void saveDiceBag(DiceBagModel bag, File f) {
        bag.saveToFile(f);
        this.setChanged();
        this.notifyObservers(new DiceBagMessage(64, bag));
    }

    public void saveDiceBag(DiceBagModel bag) {
        this.saveDiceBag(bag, new File(bag.getFilePath()));
    }
}

