// Copyright 2007 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.apache.tapestry5.ioc.annotations;

import java.lang.annotation.*;
import static java.lang.annotation.RetentionPolicy.SOURCE;

/**
 * Annotation documenting the context(s) in which tapestry-provided annotations may be used.
 * This annotation is solely for documentation purposes, is expressly not used at runtime
 * @since 5.2.0.0
 */
@Target(ElementType.ANNOTATION_TYPE)
@Retention(SOURCE)
@Documented
public @interface UseWith
{
    AnnotationUseContext[] value();
}
