/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import java.util.ArrayList;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.Prediction;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class CostCurve
implements RevisionHandler {
    public static final String RELATION_NAME = "CostCurve";
    public static final String PROB_COST_FUNC_NAME = "Probability Cost Function";
    public static final String NORM_EXPECTED_COST_NAME = "Normalized Expected Cost";
    public static final String THRESHOLD_NAME = "Threshold";

    public Instances getCurve(ArrayList<Prediction> predictions) {
        if (predictions.size() == 0) {
            return null;
        }
        return this.getCurve(predictions, ((NominalPrediction)predictions.get(0)).distribution().length - 1);
    }

    public Instances getCurve(ArrayList<Prediction> predictions, int classIndex) {
        if (predictions.size() == 0 || ((NominalPrediction)predictions.get(0)).distribution().length <= classIndex) {
            return null;
        }
        ThresholdCurve tc = new ThresholdCurve();
        Instances threshInst = tc.getCurve(predictions, classIndex);
        Instances insts = this.makeHeader();
        int fpind = threshInst.attribute("False Positive Rate").index();
        int tpind = threshInst.attribute("True Positive Rate").index();
        int threshind = threshInst.attribute(THRESHOLD_NAME).index();
        for (int i = 0; i < threshInst.numInstances(); ++i) {
            double fpval = threshInst.instance(i).value(fpind);
            double tpval = threshInst.instance(i).value(tpind);
            double thresh = threshInst.instance(i).value(threshind);
            double[] vals = new double[]{0.0, fpval, thresh};
            insts.add(new DenseInstance(1.0, vals));
            vals = new double[]{1.0, 1.0 - tpval, thresh};
            insts.add(new DenseInstance(1.0, vals));
        }
        return insts;
    }

    private Instances makeHeader() {
        ArrayList<Attribute> fv = new ArrayList<Attribute>();
        fv.add(new Attribute(PROB_COST_FUNC_NAME));
        fv.add(new Attribute(NORM_EXPECTED_COST_NAME));
        fv.add(new Attribute(THRESHOLD_NAME));
        return new Instances(RELATION_NAME, fv, 100);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15753 $");
    }
}

