/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.io.Serializable;
import java.util.Enumeration;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class Distribution
implements Cloneable,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = 8526859638230806576L;
    protected double[][] m_perClassPerBag;
    protected double[] m_perBag;
    protected double[] m_perClass;
    protected double totaL;

    public Distribution(int numBags, int numClasses) {
        this.m_perClassPerBag = new double[numBags][0];
        this.m_perBag = new double[numBags];
        this.m_perClass = new double[numClasses];
        for (int i = 0; i < numBags; ++i) {
            this.m_perClassPerBag[i] = new double[numClasses];
        }
        this.totaL = 0.0;
    }

    public Distribution(double[][] table) {
        this.m_perClassPerBag = table;
        this.m_perBag = new double[table.length];
        this.m_perClass = new double[table[0].length];
        for (int i = 0; i < table.length; ++i) {
            for (int j = 0; j < table[i].length; ++j) {
                int n = i;
                this.m_perBag[n] = this.m_perBag[n] + table[i][j];
                int n2 = j;
                this.m_perClass[n2] = this.m_perClass[n2] + table[i][j];
                this.totaL += table[i][j];
            }
        }
    }

    public Distribution(Instances source) throws Exception {
        this.m_perClassPerBag = new double[1][0];
        this.m_perBag = new double[1];
        this.totaL = 0.0;
        this.m_perClass = new double[source.numClasses()];
        this.m_perClassPerBag[0] = new double[source.numClasses()];
        Enumeration<Instance> enu = source.enumerateInstances();
        while (enu.hasMoreElements()) {
            this.add(0, enu.nextElement());
        }
    }

    public Distribution(Instances source, ClassifierSplitModel modelToUse) throws Exception {
        this.m_perClassPerBag = new double[modelToUse.numSubsets()][0];
        this.m_perBag = new double[modelToUse.numSubsets()];
        this.totaL = 0.0;
        this.m_perClass = new double[source.numClasses()];
        for (int i = 0; i < modelToUse.numSubsets(); ++i) {
            this.m_perClassPerBag[i] = new double[source.numClasses()];
        }
        Enumeration<Instance> enu = source.enumerateInstances();
        while (enu.hasMoreElements()) {
            Instance instance = enu.nextElement();
            int index = modelToUse.whichSubset(instance);
            if (index != -1) {
                this.add(index, instance);
                continue;
            }
            double[] weights = modelToUse.weights(instance);
            this.addWeights(instance, weights);
        }
    }

    public Distribution(Distribution toMerge) {
        this.totaL = toMerge.totaL;
        this.m_perClass = new double[toMerge.numClasses()];
        System.arraycopy(toMerge.m_perClass, 0, this.m_perClass, 0, toMerge.numClasses());
        this.m_perClassPerBag = new double[1][0];
        this.m_perClassPerBag[0] = new double[toMerge.numClasses()];
        System.arraycopy(toMerge.m_perClass, 0, this.m_perClassPerBag[0], 0, toMerge.numClasses());
        this.m_perBag = new double[1];
        this.m_perBag[0] = this.totaL;
    }

    public Distribution(Distribution toMerge, int index) {
        this.totaL = toMerge.totaL;
        this.m_perClass = new double[toMerge.numClasses()];
        System.arraycopy(toMerge.m_perClass, 0, this.m_perClass, 0, toMerge.numClasses());
        this.m_perClassPerBag = new double[2][0];
        this.m_perClassPerBag[0] = new double[toMerge.numClasses()];
        System.arraycopy(toMerge.m_perClassPerBag[index], 0, this.m_perClassPerBag[0], 0, toMerge.numClasses());
        this.m_perClassPerBag[1] = new double[toMerge.numClasses()];
        for (int i = 0; i < toMerge.numClasses(); ++i) {
            this.m_perClassPerBag[1][i] = toMerge.m_perClass[i] - this.m_perClassPerBag[0][i];
        }
        this.m_perBag = new double[2];
        this.m_perBag[0] = toMerge.m_perBag[index];
        this.m_perBag[1] = this.totaL - this.m_perBag[0];
    }

    public final int actualNumBags() {
        int returnValue = 0;
        for (int i = 0; i < this.m_perBag.length; ++i) {
            if (!Utils.gr(this.m_perBag[i], 0.0)) continue;
            ++returnValue;
        }
        return returnValue;
    }

    public final int actualNumClasses() {
        int returnValue = 0;
        for (int i = 0; i < this.m_perClass.length; ++i) {
            if (!Utils.gr(this.m_perClass[i], 0.0)) continue;
            ++returnValue;
        }
        return returnValue;
    }

    public final int actualNumClasses(int bagIndex) {
        int returnValue = 0;
        for (int i = 0; i < this.m_perClass.length; ++i) {
            if (!Utils.gr(this.m_perClassPerBag[bagIndex][i], 0.0)) continue;
            ++returnValue;
        }
        return returnValue;
    }

    public final void add(int bagIndex, Instance instance) throws Exception {
        int classIndex = (int)instance.classValue();
        double weight = instance.weight();
        this.m_perClassPerBag[bagIndex][classIndex] = this.m_perClassPerBag[bagIndex][classIndex] + weight;
        this.m_perBag[bagIndex] = this.m_perBag[bagIndex] + weight;
        this.m_perClass[classIndex] = this.m_perClass[classIndex] + weight;
        this.totaL += weight;
    }

    public final void sub(int bagIndex, Instance instance) throws Exception {
        int classIndex = (int)instance.classValue();
        double weight = instance.weight();
        this.m_perClassPerBag[bagIndex][classIndex] = this.m_perClassPerBag[bagIndex][classIndex] - weight;
        this.m_perBag[bagIndex] = this.m_perBag[bagIndex] - weight;
        this.m_perClass[classIndex] = this.m_perClass[classIndex] - weight;
        this.totaL -= weight;
    }

    public final void add(int bagIndex, double[] counts) {
        int i;
        double sum = Utils.sum(counts);
        for (i = 0; i < counts.length; ++i) {
            double[] dArray = this.m_perClassPerBag[bagIndex];
            int n = i;
            dArray[n] = dArray[n] + counts[i];
        }
        this.m_perBag[bagIndex] = this.m_perBag[bagIndex] + sum;
        for (i = 0; i < counts.length; ++i) {
            this.m_perClass[i] = this.m_perClass[i] + counts[i];
        }
        this.totaL += sum;
    }

    public final void addInstWithUnknown(Instances source, int attIndex) throws Exception {
        int j;
        double[] probs = new double[this.m_perBag.length];
        for (j = 0; j < this.m_perBag.length; ++j) {
            probs[j] = Utils.eq(this.totaL, 0.0) ? 1.0 / (double)probs.length : this.m_perBag[j] / this.totaL;
        }
        Enumeration<Instance> enu = source.enumerateInstances();
        while (enu.hasMoreElements()) {
            Instance instance = enu.nextElement();
            if (!instance.isMissing(attIndex)) continue;
            int classIndex = (int)instance.classValue();
            double weight = instance.weight();
            this.m_perClass[classIndex] = this.m_perClass[classIndex] + weight;
            this.totaL += weight;
            for (j = 0; j < this.m_perBag.length; ++j) {
                double newWeight = probs[j] * weight;
                this.m_perClassPerBag[j][classIndex] = this.m_perClassPerBag[j][classIndex] + newWeight;
                this.m_perBag[j] = this.m_perBag[j] + newWeight;
            }
        }
    }

    public final void addRange(int bagIndex, Instances source, int startIndex, int lastPlusOne) throws Exception {
        double sumOfWeights = 0.0;
        for (int i = startIndex; i < lastPlusOne; ++i) {
            Instance instance = source.instance(i);
            int classIndex = (int)instance.classValue();
            sumOfWeights += instance.weight();
            double[] dArray = this.m_perClassPerBag[bagIndex];
            int n = classIndex;
            dArray[n] = dArray[n] + instance.weight();
            int n2 = classIndex;
            this.m_perClass[n2] = this.m_perClass[n2] + instance.weight();
        }
        int n = bagIndex;
        this.m_perBag[n] = this.m_perBag[n] + sumOfWeights;
        this.totaL += sumOfWeights;
    }

    public final void addWeights(Instance instance, double[] weights) throws Exception {
        int classIndex = (int)instance.classValue();
        for (int i = 0; i < this.m_perBag.length; ++i) {
            double weight = instance.weight() * weights[i];
            this.m_perClassPerBag[i][classIndex] = this.m_perClassPerBag[i][classIndex] + weight;
            this.m_perBag[i] = this.m_perBag[i] + weight;
            this.m_perClass[classIndex] = this.m_perClass[classIndex] + weight;
            this.totaL += weight;
        }
    }

    public final boolean check(double minNoObj) {
        int counter = 0;
        for (int i = 0; i < this.m_perBag.length; ++i) {
            if (!Utils.grOrEq(this.m_perBag[i], minNoObj)) continue;
            ++counter;
        }
        return counter > 1;
    }

    public final Object clone() {
        int j;
        Distribution newDistribution = new Distribution(this.m_perBag.length, this.m_perClass.length);
        for (int i = 0; i < this.m_perBag.length; ++i) {
            newDistribution.m_perBag[i] = this.m_perBag[i];
            for (j = 0; j < this.m_perClass.length; ++j) {
                newDistribution.m_perClassPerBag[i][j] = this.m_perClassPerBag[i][j];
            }
        }
        for (j = 0; j < this.m_perClass.length; ++j) {
            newDistribution.m_perClass[j] = this.m_perClass[j];
        }
        newDistribution.totaL = this.totaL;
        return newDistribution;
    }

    public final void del(int bagIndex, Instance instance) throws Exception {
        int classIndex = (int)instance.classValue();
        double weight = instance.weight();
        this.m_perClassPerBag[bagIndex][classIndex] = this.m_perClassPerBag[bagIndex][classIndex] - weight;
        this.m_perBag[bagIndex] = this.m_perBag[bagIndex] - weight;
        this.m_perClass[classIndex] = this.m_perClass[classIndex] - weight;
        this.totaL -= weight;
    }

    public final void delRange(int bagIndex, Instances source, int startIndex, int lastPlusOne) throws Exception {
        double sumOfWeights = 0.0;
        for (int i = startIndex; i < lastPlusOne; ++i) {
            Instance instance = source.instance(i);
            int classIndex = (int)instance.classValue();
            sumOfWeights += instance.weight();
            double[] dArray = this.m_perClassPerBag[bagIndex];
            int n = classIndex;
            dArray[n] = dArray[n] - instance.weight();
            int n2 = classIndex;
            this.m_perClass[n2] = this.m_perClass[n2] - instance.weight();
        }
        int n = bagIndex;
        this.m_perBag[n] = this.m_perBag[n] - sumOfWeights;
        this.totaL -= sumOfWeights;
    }

    public final String dumpDistribution() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.m_perBag.length; ++i) {
            text.append("Bag num " + i + "\n");
            for (int j = 0; j < this.m_perClass.length; ++j) {
                text.append("Class num " + j + " " + this.m_perClassPerBag[i][j] + "\n");
            }
        }
        return text.toString();
    }

    public final void initialize() {
        int i;
        for (i = 0; i < this.m_perClass.length; ++i) {
            this.m_perClass[i] = 0.0;
        }
        for (i = 0; i < this.m_perBag.length; ++i) {
            this.m_perBag[i] = 0.0;
        }
        for (i = 0; i < this.m_perBag.length; ++i) {
            for (int j = 0; j < this.m_perClass.length; ++j) {
                this.m_perClassPerBag[i][j] = 0.0;
            }
        }
        this.totaL = 0.0;
    }

    public final double[][] matrix() {
        return this.m_perClassPerBag;
    }

    public final int maxBag() {
        double max = 0.0;
        int maxIndex = -1;
        for (int i = 0; i < this.m_perBag.length; ++i) {
            if (!Utils.grOrEq(this.m_perBag[i], max)) continue;
            max = this.m_perBag[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public final int maxClass() {
        double maxCount = 0.0;
        int maxIndex = 0;
        for (int i = 0; i < this.m_perClass.length; ++i) {
            if (!Utils.gr(this.m_perClass[i], maxCount)) continue;
            maxCount = this.m_perClass[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public final int maxClass(int index) {
        double maxCount = 0.0;
        int maxIndex = 0;
        if (Utils.gr(this.m_perBag[index], 0.0)) {
            for (int i = 0; i < this.m_perClass.length; ++i) {
                if (!Utils.gr(this.m_perClassPerBag[index][i], maxCount)) continue;
                maxCount = this.m_perClassPerBag[index][i];
                maxIndex = i;
            }
            return maxIndex;
        }
        return this.maxClass();
    }

    public final int numBags() {
        return this.m_perBag.length;
    }

    public final int numClasses() {
        return this.m_perClass.length;
    }

    public final double numCorrect() {
        return this.m_perClass[this.maxClass()];
    }

    public final double numCorrect(int index) {
        return this.m_perClassPerBag[index][this.maxClass(index)];
    }

    public final double numIncorrect() {
        return this.totaL - this.numCorrect();
    }

    public final double numIncorrect(int index) {
        return this.m_perBag[index] - this.numCorrect(index);
    }

    public final double perClassPerBag(int bagIndex, int classIndex) {
        return this.m_perClassPerBag[bagIndex][classIndex];
    }

    public final double perBag(int bagIndex) {
        return this.m_perBag[bagIndex];
    }

    public final double perClass(int classIndex) {
        return this.m_perClass[classIndex];
    }

    public final double laplaceProb(int classIndex) {
        return (this.m_perClass[classIndex] + 1.0) / (this.totaL + (double)this.m_perClass.length);
    }

    public final double laplaceProb(int classIndex, int intIndex) {
        if (Utils.gr(this.m_perBag[intIndex], 0.0)) {
            return (this.m_perClassPerBag[intIndex][classIndex] + 1.0) / (this.m_perBag[intIndex] + (double)this.m_perClass.length);
        }
        return this.laplaceProb(classIndex);
    }

    public final double prob(int classIndex) {
        if (!Utils.eq(this.totaL, 0.0)) {
            return this.m_perClass[classIndex] / this.totaL;
        }
        return 0.0;
    }

    public final double prob(int classIndex, int intIndex) {
        if (Utils.gr(this.m_perBag[intIndex], 0.0)) {
            return this.m_perClassPerBag[intIndex][classIndex] / this.m_perBag[intIndex];
        }
        return this.prob(classIndex);
    }

    public final Distribution subtract(Distribution toSubstract) {
        Distribution newDist = new Distribution(1, this.m_perClass.length);
        newDist.m_perBag[0] = this.totaL - toSubstract.totaL;
        newDist.totaL = newDist.m_perBag[0];
        for (int i = 0; i < this.m_perClass.length; ++i) {
            newDist.m_perClassPerBag[0][i] = this.m_perClass[i] - toSubstract.m_perClass[i];
            newDist.m_perClass[i] = newDist.m_perClassPerBag[0][i];
        }
        return newDist;
    }

    public final double total() {
        return this.totaL;
    }

    public final void shift(int from, int to, Instance instance) throws Exception {
        int classIndex = (int)instance.classValue();
        double weight = instance.weight();
        double[] dArray = this.m_perClassPerBag[from];
        int n = classIndex;
        dArray[n] = dArray[n] - weight;
        double[] dArray2 = this.m_perClassPerBag[to];
        int n2 = classIndex;
        dArray2[n2] = dArray2[n2] + weight;
        int n3 = from;
        this.m_perBag[n3] = this.m_perBag[n3] - weight;
        int n4 = to;
        this.m_perBag[n4] = this.m_perBag[n4] + weight;
    }

    public final void shiftRange(int from, int to, Instances source, int startIndex, int lastPlusOne) throws Exception {
        for (int i = startIndex; i < lastPlusOne; ++i) {
            Instance instance = source.instance(i);
            int classIndex = (int)instance.classValue();
            double weight = instance.weight();
            double[] dArray = this.m_perClassPerBag[from];
            int n = classIndex;
            dArray[n] = dArray[n] - weight;
            double[] dArray2 = this.m_perClassPerBag[to];
            int n2 = classIndex;
            dArray2[n2] = dArray2[n2] + weight;
            int n3 = from;
            this.m_perBag[n3] = this.m_perBag[n3] - weight;
            int n4 = to;
            this.m_perBag[n4] = this.m_perBag[n4] + weight;
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15123 $");
    }
}

