/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "Dice.h"

Dice::Dice(int type){
  this->type=type;
  srand((unsigned)time(0));
}

Dice::~Dice(){;}

int Dice::roll(){
  switch(type){  
  case D66:
    return (1+(int) (6.0*rand()/(RAND_MAX+1.0)))*10 + (1+(int) (6.0*rand()/(RAND_MAX+1.0)));
  case DBLOCK:
    return ((int) (6.0*rand()/(RAND_MAX+1.0)));
  default:
    return (1+(int) (((double)type)*rand()/(RAND_MAX+1.0)));
  }
}

int Dice::roll(int i){
  int val=0;
  while(i-- > 0) val+=roll();
  return val;
}

