/* ex: set ts=4 noet: */
/* provides a generic linked list and related facilties */

#ifndef UTIL_LIST_H
#define UTIL_LIST_H

#include "setup.h"
#include "types.h"

typedef struct _list_node_t list_node_t;

struct _list_node_t {
	void *data;
	list_node_t *prev, *next;
};

typedef struct {
	list_node_t *first, *last;
	size_t nodes; /* number of items in the list */
} list_t;


#define list_first(list)			((list)->first)
#define list_last(list)				((list)->last)
#define list_size(list)				((list)->nodes)
#define list_bytes(list)			((list)->bytes)
#define list_node_prev(node)		(((NULL == (node)) ? NULL : (node)->prev))
#define list_node_next(node)		(((NULL == (node)) ? NULL : (node)->next))
#define list_node_data(node)		(((NULL == (node)) ? NULL : (node)->data))

/* NOTE: put 'const' wherever possible! */
/* list creation and destruction */
list_t * list_new(void); /* create a list */
bool  list_init(list_t *); /* initialize a list */
bool list_destroy(list_t *, void (*)(void *)); /* clear internals of list */
bool list_free(list_t *, void (*)(void *)); /* free an entire list header and all its node */
bool list_node_detach(list_t *, list_node_t *);
bool list_node_free(list_node_t *, void (*)(void *)); /* free a node using an external function */
bool list_nodes_free(list_t *, void (*)(void *)); /* empty a list, but keep the head */
#if 0
/* NOTE: i want to implement this */
void *list_dupe(void (*)(const void *)); /* duplicate an existing list_t* and all nodes */
#endif
void list_head_free(list_t *); /* free only the head of a list (free nodes before you call this!) */

list_node_t * list_nth_node(list_t *, int);
void * list_nth(list_t *, int);

/* adding and removing elements */
list_node_t *list_node_new(const void *, const size_t); /* create a new node with size_t bytes from the void * */
list_node_t *list_node_deep_new(const void *, void *(*)(const void *)); /* create a new node using output from an external "dupe" function */
#if 0
#define list_node_new_deep(v, cb)	(list_node_deep_new(v, cb)) /* DEPRECATED */
#endif
list_node_t * list_node_ptr_new(void *); /* create a new node with data as a pointer */ /* DEPRECATED */
list_node_t * list_prepend(list_t *, list_node_t *); /* add a node to the beginning of a list */
list_node_t * list_prepend_ptr(list_t *, void *); /* add a node to the beginning of a list */
list_node_t * list_append(list_t *, list_node_t *); /* add a node to the end of a list */
list_node_t * list_append_ptr(list_t *, void *); /* append pointer */
list_node_t * list_insert_before(list_t *, list_node_t *, list_node_t *);
list_node_t * list_insert_before_ptr(list_t *, list_node_t *, void *);
void * list_pop(list_t *);
void * list_shift(list_t *);
bool list_remove(list_t *, list_node_t *, void (*)(void *)); /* remove a node, using an external function to free the node data */

/* list examination */
void list_dump(list_t *, void (*)(const void *)); /* display of a list head and all its node to stdout using an external display function */

/* performing actions on every member of a list */
void list_map(list_t *, void (*)(void *)); /* apply a function to each member of the list, first->last */
void list_map_node(list_t *, void (*)(list_node_t *)); /* apply a function to each member of the list, first->last */
/* FIXME: unimplemented */
bool list_sort(list_t *, int (*)(const void *, const void *)); /* sort list */

#endif /* #ifndef LIST_H */

