/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.psi.java1.nfc;

import com.phidgets.Phidget;
import com.phidgets.RFIDPhidget;
import com.phidgets.event.TagGainEvent;
import com.phidgets.event.TagGainListener;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.microedition.contactless.DiscoveryManager;
import javax.microedition.contactless.TargetListener;
import javax.microedition.contactless.TargetProperties;
import javax.microedition.midlet.ApplicationManager;
import org.me4se.Initializer;
import org.me4se.psi.java1.nfc.SimpleTargetProperties;
import org.me4se.psi.java1.nfc.TargetListenerContainer;

public class ContactlessInitializer
implements Initializer,
ActionListener,
TagGainListener {
    private MenuItem rfidTagMenuItem;
    private MenuItem ndefTagMenuItem;
    private MenuItem iso14443TagMenuItem;
    private MenuItem enablePhidgetRfid;
    private MenuItem disablePhidgetRfid;
    private RFIDPhidget rfid;

    public void initialize(ApplicationManager manager) {
        MenuBar menuBar = manager.frame.getMenuBar();
        Menu contactlessMenu = new Menu("NFC");
        this.rfidTagMenuItem = new MenuItem("RFID Tag in range...");
        this.rfidTagMenuItem.addActionListener(this);
        contactlessMenu.add(this.rfidTagMenuItem);
        this.ndefTagMenuItem = new MenuItem("NDEF Tag in range...");
        this.ndefTagMenuItem.addActionListener(this);
        contactlessMenu.add(this.ndefTagMenuItem);
        this.iso14443TagMenuItem = new MenuItem("ISO14443 Tag in range...");
        this.iso14443TagMenuItem.addActionListener(this);
        contactlessMenu.add(this.iso14443TagMenuItem);
        contactlessMenu.addSeparator();
        this.enablePhidgetRfid = new MenuItem("Enable Phidget RFID reader");
        this.enablePhidgetRfid.addActionListener(this);
        contactlessMenu.add(this.enablePhidgetRfid);
        this.disablePhidgetRfid = new MenuItem("Disable Phidget RFID reader");
        this.disablePhidgetRfid.addActionListener(this);
        this.disablePhidgetRfid.setEnabled(false);
        contactlessMenu.add(this.disablePhidgetRfid);
        menuBar.add(contactlessMenu);
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.enablePhidgetRfid) {
            this.enablePhidgetRfid.setEnabled(false);
            this.disablePhidgetRfid.setEnabled(true);
            try {
                System.out.println(Phidget.getLibraryVersion());
                this.rfid = new RFIDPhidget();
                this.rfid.addTagGainListener((TagGainListener)this);
                this.rfid.openAny();
                this.rfid.waitForAttachment(1000);
                this.rfid.setAntennaOn(true);
                this.rfid.setLEDOn(true);
            }
            catch (Exception ex) {
                System.out.println("ME4SE Phidget Error: " + ex.getMessage());
            }
        } else if (source == this.disablePhidgetRfid) {
            this.enablePhidgetRfid.setEnabled(true);
            this.disablePhidgetRfid.setEnabled(false);
            try {
                if (this.rfid != null) {
                    this.rfid.setAntennaOn(false);
                }
                this.rfid.setLEDOn(false);
                this.rfid.close();
                this.rfid = null;
            }
            catch (Exception ex) {
                System.out.println("ME4SE Phidget Error: " + ex.getMessage());
            }
        } else if (source == this.rfidTagMenuItem) {
            Vector listeners = DiscoveryManager.targetListeners;
            for (int i = 0; i < listeners.size(); ++i) {
                TargetListenerContainer cont = (TargetListenerContainer)listeners.elementAt(i);
                TargetListener listener = cont.getListener();
                listener.targetDetected(new TargetProperties[]{new SimpleTargetProperties("0011224455")});
            }
        } else if (source == this.ndefTagMenuItem) {
            System.out.println("ME4SE: NDEF Tag in Range !");
        } else if (source == this.iso14443TagMenuItem) {
            System.out.println("ME4SE: ISO14443 Tag in Range !");
        }
    }

    public void tagGained(TagGainEvent tagGainEvent) {
        System.out.println(tagGainEvent.getValue());
        Vector listeners = DiscoveryManager.targetListeners;
        for (int i = 0; i < listeners.size(); ++i) {
            TargetListenerContainer cont = (TargetListenerContainer)listeners.elementAt(i);
            TargetListener listener = cont.getListener();
            listener.targetDetected(new TargetProperties[]{new SimpleTargetProperties(tagGainEvent.getValue())});
        }
    }
}

