/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.internal.tasks.options.AbstractOptionElement;
import org.gradle.api.internal.tasks.options.BooleanOptionElement;
import org.gradle.api.internal.tasks.options.MultipleValueOptionElement;
import org.gradle.api.internal.tasks.options.OptionElement;
import org.gradle.api.internal.tasks.options.OptionValidationException;
import org.gradle.api.internal.tasks.options.OptionValueNotationParserFactory;
import org.gradle.api.internal.tasks.options.PropertySetter;
import org.gradle.api.provider.HasMultipleValues;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.model.internal.type.ModelType;

public class MethodOptionElement {
    private static String assertValidOptionName(Option option, String elementName, Class<?> declaredClass) {
        if (option.option().length() == 0) {
            throw new OptionValidationException(String.format("No option name set on '%s' in class '%s'.", elementName, declaredClass.getName()));
        }
        return option.option();
    }

    public static OptionElement create(Option option, Method method, OptionValueNotationParserFactory optionValueNotationParserFactory) {
        String optionName = MethodOptionElement.assertValidOptionName(option, method.getName(), method.getDeclaringClass());
        if (Property.class.isAssignableFrom(method.getReturnType())) {
            MethodOptionElement.assertCanUseMethodReturnType(optionName, method);
            PropertySetter setter = MethodOptionElement.mutateUsingReturnValue(method);
            return AbstractOptionElement.of(optionName, option, setter, optionValueNotationParserFactory);
        }
        if (HasMultipleValues.class.isAssignableFrom(method.getReturnType())) {
            MethodOptionElement.assertCanUseMethodReturnType(optionName, method);
            PropertySetter setter = MethodOptionElement.mutateUsingReturnValue(method);
            Class<?> elementType = setter.getRawType();
            return new MultipleValueOptionElement(optionName, option, elementType, setter, optionValueNotationParserFactory);
        }
        if (method.getParameterTypes().length == 0) {
            return new BooleanOptionElement(optionName, option, MethodOptionElement.setFlagUsingMethod(method));
        }
        MethodOptionElement.assertCanUseMethodParam(optionName, method);
        PropertySetter setter = MethodOptionElement.mutateUsingParameter(method);
        return AbstractOptionElement.of(optionName, option, setter, optionValueNotationParserFactory);
    }

    private static PropertySetter setFlagUsingMethod(Method method) {
        return new MethodInvokingSetter(method);
    }

    private static PropertySetter mutateUsingParameter(Method method) {
        return new MethodPropertySetter(method);
    }

    private static PropertySetter mutateUsingReturnValue(Method method) {
        if (HasMultipleValues.class.isAssignableFrom(method.getReturnType())) {
            return new MultipleValuePropertyValueSetter(method);
        }
        if (FileSystemLocationProperty.class.isAssignableFrom(method.getReturnType())) {
            return new FileSystemLocationPropertyValueSetter(method);
        }
        return new PropertyValueSetter(method);
    }

    private static void assertCanUseMethodReturnType(String optionName, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 0) {
            throw new OptionValidationException(String.format("Option '%s' on method that returns %s cannot take parameters in class '%s#%s'.", optionName, method.getGenericReturnType(), method.getDeclaringClass().getName(), method.getName()));
        }
    }

    private static void assertCanUseMethodParam(String optionName, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 1) {
            throw new OptionValidationException(String.format("Option '%s' on method cannot take multiple parameters in class '%s#%s'.", optionName, method.getDeclaringClass().getName(), method.getName()));
        }
    }

    private static class MethodInvokingSetter
    implements PropertySetter {
        private final Method method;

        public MethodInvokingSetter(Method method) {
            this.method = method;
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.method.getDeclaringClass();
        }

        @Override
        public Class<?> getRawType() {
            return Void.TYPE;
        }

        @Override
        public Type getGenericType() {
            return Void.TYPE;
        }

        @Override
        public void setValue(Object object, Object value) {
            JavaMethod.of(Object.class, (Method)this.method).invoke(object, new Object[0]);
        }
    }

    @NonNullApi
    private static class FileSystemLocationPropertyValueSetter
    extends PropertyValueSetter {
        public FileSystemLocationPropertyValueSetter(Method method) {
            super(method, FileSystemLocation.class);
        }

        @Override
        public void setValue(Object target, Object value) {
            FileSystemLocationProperty property = (FileSystemLocationProperty)Cast.uncheckedNonnullCast((Object)JavaMethod.of(Object.class, (Method)this.getMethod()).invoke(target, new Object[0]));
            property.set(new File((String)value));
        }
    }

    @NonNullApi
    private static class MultipleValuePropertyValueSetter
    extends PropertyValueSetter {
        public MultipleValuePropertyValueSetter(Method method) {
            super(method);
        }

        @Override
        public void setValue(Object target, Object value) {
            HasMultipleValues property = (HasMultipleValues)Cast.uncheckedNonnullCast((Object)JavaMethod.of(Object.class, (Method)this.getMethod()).invoke(target, new Object[0]));
            property.set((Iterable)value);
        }
    }

    private static class PropertyValueSetter
    implements PropertySetter {
        private final Method method;
        private final Class<?> elementType;

        public PropertyValueSetter(Method method) {
            this(method, ((ModelType)ModelType.of((Type)method.getGenericReturnType()).getTypeVariables().get(0)).getRawClass());
        }

        public PropertyValueSetter(Method method, Class<?> elementType) {
            this.method = method;
            this.elementType = elementType;
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.method.getDeclaringClass();
        }

        @Override
        public Class<?> getRawType() {
            return this.elementType;
        }

        @Override
        public Type getGenericType() {
            return this.elementType;
        }

        @Override
        public void setValue(Object target, Object value) {
            Property property = (Property)Cast.uncheckedNonnullCast((Object)JavaMethod.of(Object.class, (Method)this.method).invoke(target, new Object[0]));
            property.set(value);
        }

        protected Method getMethod() {
            return this.method;
        }
    }

    private static class MethodPropertySetter
    implements PropertySetter {
        private final Method method;

        public MethodPropertySetter(Method method) {
            this.method = method;
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.method.getDeclaringClass();
        }

        @Override
        public Class<?> getRawType() {
            return this.method.getParameterTypes()[0];
        }

        @Override
        public Type getGenericType() {
            return this.method.getGenericParameterTypes()[0];
        }

        @Override
        public void setValue(Object target, Object value) {
            JavaMethod.of(Object.class, (Method)this.method).invoke(target, new Object[]{value});
        }
    }
}

