/******************************************************************************
 *{@C
 *      Copyright:      2005-2022 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dSDL
 *      Filename:       sdl.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG module for wrapping the SDL library.
 *
 *****************************************************************************/

%module sdl

%{
    #if defined (WIN32)
        #include <windows.h>
        #include <wingdi.h>
    #endif

    #include "SDL.h"
%}

%include tcl3dDefines.i

// SDL specific macros.
#define DECLSPEC
#define SDLCALL
#define SDL_PRINTF_FORMAT_STRING
#define SDL_PRINTF_VARARG_FUNC(fmtargnumber)
#define SDL_FORCE_INLINE
#define SDL_DEPRECATED

%ignore SDL_AudioCVT;
%ignore SDL_vsscanf;
%ignore SDL_vsnprintf;
%ignore SDL_vasprintf;

%include "SDL_stdinc.h"
%include "SDL.h"
%include "SDL_error.h"
%include "SDL_timer.h"
%include "SDL_loadso.h"
// Does not work with SDL 2.0.20 anymore.
// %include "SDL_thread.h"
%include "SDL_timer.h"
%include "SDL_joystick.h"
%include "SDL_mouse.h"
%include "SDL_events.h"
%include "SDL_video.h"
%include "SDL_version.h"
%include "SDL_audio.h"
