/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.sequences;

import java.util.List;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.wizard.components.WizardComponent;
import org.netbeans.installer.wizard.components.WizardSequence;

public class ProductWizardSequence
extends WizardSequence {
    private Product product;

    public ProductWizardSequence(Product product) {
        this.product = product;
    }

    @Override
    public void executeForward() {
        this.childWizard = this.getWizard().createSubWizard(this.product.getWizardComponents(), -1, this.product, this.product.getClassLoader());
        this.childWizard.getContext().put(this.product);
        this.childWizard.next();
    }

    @Override
    public void executeBackward() {
        this.childWizard = this.getWizard().createSubWizard(this.product.getWizardComponents(), this.product.getWizardComponents().size(), this.product, this.product.getClassLoader());
        this.childWizard.getContext().put(this.product);
        this.childWizard.previous();
    }

    @Override
    public boolean canExecuteForward() {
        if (this.product.isLogicDownloaded()) {
            List<WizardComponent> components = this.product.getWizardComponents();
            for (int i = 0; i < components.size(); ++i) {
                WizardComponent component = components.get(i);
                if (!component.canExecuteForward()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canExecuteBackward() {
        if (this.product.isLogicDownloaded()) {
            List<WizardComponent> components = this.product.getWizardComponents();
            for (int i = components.size() - 1; i > -1; --i) {
                WizardComponent component = components.get(i);
                if (component.canExecuteBackward()) {
                    return true;
                }
                if (!component.isPointOfNoReturn()) continue;
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isPointOfNoReturn() {
        if (this.product.isLogicDownloaded()) {
            List<WizardComponent> components = this.product.getWizardComponents();
            if (this.childWizard != null) {
                for (int i = 0; i < components.size(); ++i) {
                    if (!components.get(i).isPointOfNoReturn() || i >= this.childWizard.getIndex()) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

