/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TwoStateHoverProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.animator.SceneAnimator;
import org.netbeans.api.visual.laf.InputBindings;
import org.netbeans.api.visual.laf.LookFeel;
import org.netbeans.api.visual.widget.BirdViewController;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.ResourceTable;
import org.netbeans.api.visual.widget.SceneComponent;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;
import org.netbeans.modules.visual.widget.SatelliteComponent;

public class Scene
extends Widget {
    private double zoomFactor = 1.0;
    private SceneAnimator sceneAnimator;
    private JComponent component = null;
    private Graphics2D graphics = null;
    private boolean viewShowing = false;
    private boolean paintEverything = true;
    private Rectangle repaintRegion = null;
    private HashSet<Widget> repaintWidgets = new HashSet();
    private Font defaultFont;
    private LookFeel lookFeel = LookFeel.createDefaultLookFeel();
    private InputBindings inputBindings = InputBindings.create();
    private String activeTool = null;
    private Rectangle maximumBounds = new Rectangle(-1073741824, -1073741824, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private final ArrayList<SceneListener> sceneListeners = new ArrayList();
    private EventProcessingType keyEventProcessingType = EventProcessingType.ALL_WIDGETS;
    private WidgetAction.Chain priorActions = new WidgetAction.Chain();
    private Widget focusedWidget = this;
    private WidgetAction widgetHoverAction;
    boolean extendSceneOnly = false;
    private ResourceTable resourceTable = null;

    public Scene() {
        super(null);
        this.defaultFont = Font.decode(null);
        this.resolveBounds(new Point(), new Rectangle());
        this.setOpaque(true);
        this.setFont(this.defaultFont);
        this.setBackground(this.lookFeel.getBackground());
        this.setForeground(this.lookFeel.getForeground());
        this.sceneAnimator = new SceneAnimator(this);
    }

    public JComponent createView() {
        assert (this.component == null);
        this.component = new SceneComponent(this);
        this.component.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                Scene.this.repaintSatellite();
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                Scene.this.repaintSatellite();
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        return this.component;
    }

    public JComponent getView() {
        return this.component;
    }

    public JComponent createSatelliteView() {
        return new SatelliteComponent(this);
    }

    public BirdViewController createBirdView() {
        return new BirdViewController(this);
    }

    void setViewShowing(boolean bl) {
        assert (this.viewShowing != bl) : "Duplicate setViewShowing: " + bl;
        this.viewShowing = bl;
        if (bl) {
            this.dispatchNotifyAddedCore();
        } else {
            this.dispatchNotifyRemovedCore();
        }
    }

    void dispatchNotifyAdded(Widget widget) {
        assert (widget != null);
        Widget widget2 = widget;
        while (widget2 != this) {
            if ((widget2 = widget2.getParentWidget()) != null) continue;
            return;
        }
        if (!this.viewShowing) {
            return;
        }
        widget.dispatchNotifyAddedCore();
    }

    void dispatchNotifyRemoved(Widget widget) {
        assert (widget != null);
        Widget widget2 = widget;
        do {
            if (widget2 != this) continue;
            if (!this.viewShowing) break;
            return;
        } while ((widget2 = widget2.getParentWidget()) != null);
        if (!this.viewShowing) {
            return;
        }
        widget.dispatchNotifyRemovedCore();
    }

    @Override
    public final Graphics2D getGraphics() {
        return this.graphics;
    }

    final void setGraphics(Graphics2D graphics2D) {
        this.graphics = graphics2D;
    }

    public final void validate(Graphics2D graphics2D) {
        Graphics2D graphics2D2 = this.getGraphics();
        this.setGraphics(graphics2D);
        this.validate();
        this.setGraphics(graphics2D2);
    }

    public final void paint(Graphics2D graphics2D) {
        this.validate();
        Graphics2D graphics2D2 = this.getGraphics();
        this.setGraphics(graphics2D);
        this.paint();
        this.setGraphics(graphics2D2);
    }

    public final Rectangle getMaximumBounds() {
        return new Rectangle(this.maximumBounds);
    }

    public final void setMaximumBounds(Rectangle rectangle) {
        assert (rectangle != null);
        this.maximumBounds = new Rectangle(rectangle);
        this.revalidate();
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    @Override
    public boolean isValidated() {
        return super.isValidated() && this.repaintRegion == null && this.repaintWidgets.isEmpty();
    }

    @Override
    protected boolean isRepaintRequiredForRevalidating() {
        return false;
    }

    final void revalidateWidget(Widget widget) {
        Rectangle rectangle = widget.getBounds();
        if (rectangle != null) {
            Rectangle rectangle2 = widget.convertLocalToScene(rectangle);
            if (this.repaintRegion == null) {
                this.repaintRegion = rectangle2;
            } else {
                this.repaintRegion.add(rectangle2);
            }
        }
        this.repaintWidgets.add(widget);
    }

    /*
     * WARNING - void declaration
     */
    private void layoutScene() {
        Object object;
        Cloneable cloneable;
        Point point = this.getLocation();
        Rectangle rectangle = this.getBounds();
        this.layout(false);
        this.resolveBounds(null, null);
        this.justify();
        Rectangle rectangle2 = null;
        for (Widget object22 : this.getChildren()) {
            cloneable = object22.getLocation();
            Rectangle rectangle3 = object22.getBounds();
            rectangle3.translate(cloneable.x, cloneable.y);
            if (rectangle2 == null) {
                rectangle2 = rectangle3;
                continue;
            }
            rectangle2.add(rectangle3);
        }
        if (rectangle2 != null) {
            object = this.getBorder().getInsets();
            rectangle2.x -= ((Insets)object).left;
            rectangle2.y -= ((Insets)object).top;
            rectangle2.width += ((Insets)object).left + ((Insets)object).right;
            rectangle2.height += ((Insets)object).top + ((Insets)object).bottom;
            rectangle2 = rectangle2.intersection(this.maximumBounds);
        }
        if (this.extendSceneOnly && rectangle2 != null && rectangle != null) {
            rectangle2.add(new Rectangle(rectangle.x + point.x, rectangle.y + point.y, rectangle.width, rectangle.height));
        }
        this.resolveBounds(rectangle2 != null ? new Point(-rectangle2.x, -rectangle2.y) : new Point(), rectangle2);
        object = rectangle2 != null ? rectangle2.getSize() : new Dimension();
        object = new Dimension((int)((double)((Dimension)object).width * this.zoomFactor), (int)((double)((Dimension)object).height * this.zoomFactor));
        Rectangle rectangle4 = this.getBounds();
        if (this.component != null) {
            void var5_8;
            if (!((Dimension)object).equals(this.component.getPreferredSize())) {
                this.component.setPreferredSize((Dimension)object);
                this.component.revalidate();
                Rectangle rectangle5 = this.getBounds();
            }
            cloneable = this.component.getSize();
            ((Dimension)cloneable).width = (int)((double)((Dimension)cloneable).width / this.zoomFactor);
            ((Dimension)cloneable).height = (int)((double)((Dimension)cloneable).height / this.zoomFactor);
            boolean bl = false;
            if (var5_8.width < ((Dimension)cloneable).width) {
                var5_8.width = ((Dimension)cloneable).width;
                bl = true;
            }
            if (var5_8.height < ((Dimension)cloneable).height) {
                var5_8.height = ((Dimension)cloneable).height;
                bl = true;
            }
            if (bl) {
                this.resolveBounds(this.getLocation(), (Rectangle)var5_8);
            }
        }
        if (!this.getLocation().equals(point) || !this.getBounds().equals(rectangle)) {
            cloneable = this.convertLocalToScene(this.getBounds());
            if (this.repaintRegion == null) {
                this.repaintRegion = cloneable;
            } else {
                this.repaintRegion.add((Rectangle)cloneable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void validate() {
        if (this.graphics == null) {
            return;
        }
        block2: while (!this.isValidated()) {
            SceneListener[] sceneListenerArray = this.sceneListeners;
            // MONITORENTER : this.sceneListeners
            SceneListener[] sceneListenerArray2 = this.sceneListeners.toArray(new SceneListener[this.sceneListeners.size()]);
            // MONITOREXIT : sceneListenerArray
            for (SceneListener sceneListener : sceneListenerArray2) {
                sceneListener.sceneValidating();
            }
            this.layoutScene();
            this.resolveRepaints();
            sceneListenerArray = sceneListenerArray2;
            int n = sceneListenerArray.length;
            int n2 = 0;
            while (true) {
                SceneListener sceneListener;
                if (n2 >= n) continue block2;
                sceneListener = sceneListenerArray[n2];
                sceneListener.sceneValidated();
                ++n2;
            }
            break;
        }
        return;
    }

    private void resolveRepaints() {
        assert (SwingUtilities.isEventDispatchThread());
        for (Widget widget : this.repaintWidgets) {
            Rectangle rectangle = widget.getBounds();
            if (rectangle == null) continue;
            rectangle = widget.convertLocalToScene(rectangle);
            if (this.repaintRegion != null) {
                this.repaintRegion.add(rectangle);
                continue;
            }
            this.repaintRegion = rectangle;
        }
        this.repaintWidgets.clear();
        if (this.repaintRegion != null) {
            Rectangle rectangle = this.convertSceneToView(this.repaintRegion);
            rectangle.grow(1, 1);
            if (this.component != null) {
                this.component.repaint(rectangle);
            }
            this.repaintSatellite();
            this.repaintRegion = null;
        }
    }

    void setExtendSceneOnly(boolean bl) {
        this.extendSceneOnly = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintSatellite() {
        SceneListener[] sceneListenerArray = this.sceneListeners;
        synchronized (this.sceneListeners) {
            SceneListener[] sceneListenerArray2 = this.sceneListeners.toArray(new SceneListener[this.sceneListeners.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (SceneListener sceneListener : sceneListenerArray2) {
                sceneListener.sceneRepaint();
            }
            return;
        }
    }

    final boolean isPaintEverything() {
        return this.paintEverything;
    }

    final void setPaintEverything(boolean bl) {
        this.paintEverything = bl;
    }

    public final EventProcessingType getKeyEventProcessingType() {
        return this.keyEventProcessingType;
    }

    public final void setKeyEventProcessingType(EventProcessingType eventProcessingType) {
        assert (eventProcessingType != null);
        this.keyEventProcessingType = eventProcessingType;
    }

    public final WidgetAction.Chain getPriorActions() {
        return this.priorActions;
    }

    public final Widget getFocusedWidget() {
        return this.focusedWidget;
    }

    public final void setFocusedWidget(Widget widget) {
        if (widget == null) {
            widget = this;
        } else assert (widget.getScene() == this);
        this.focusedWidget.setState(this.focusedWidget.getState().deriveWidgetFocused(false));
        this.focusedWidget = widget;
        this.focusedWidget.setState(this.focusedWidget.getState().deriveWidgetFocused(true));
    }

    public final double getZoomFactor() {
        return this.zoomFactor;
    }

    public final void setZoomFactor(double d) {
        this.zoomFactor = d;
        this.revalidate();
    }

    public final SceneAnimator getSceneAnimator() {
        return this.sceneAnimator;
    }

    public final LookFeel getLookFeel() {
        return this.lookFeel;
    }

    public final void setLookFeel(LookFeel lookFeel) {
        assert (lookFeel != null);
        this.lookFeel = lookFeel;
    }

    public final InputBindings getInputBindings() {
        return this.inputBindings;
    }

    public final String getActiveTool() {
        return this.activeTool;
    }

    public void setActiveTool(String string) {
        this.activeTool = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSceneListener(SceneListener sceneListener) {
        assert (sceneListener != null);
        ArrayList<SceneListener> arrayList = this.sceneListeners;
        synchronized (arrayList) {
            this.sceneListeners.add(sceneListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeSceneListener(SceneListener sceneListener) {
        ArrayList<SceneListener> arrayList = this.sceneListeners;
        synchronized (arrayList) {
            this.sceneListeners.remove(sceneListener);
        }
    }

    public final Point convertSceneToView(Point point) {
        Point point2 = this.getLocation();
        return new Point((int)(this.zoomFactor * (double)(point2.x + point.x)), (int)(this.zoomFactor * (double)(point2.y + point.y)));
    }

    public final Rectangle convertSceneToView(Rectangle rectangle) {
        Point point = this.getLocation();
        return GeomUtil.roundRectangle(new Rectangle2D.Double((double)(rectangle.x + point.x) * this.zoomFactor, (double)(rectangle.y + point.y) * this.zoomFactor, (double)rectangle.width * this.zoomFactor, (double)rectangle.height * this.zoomFactor));
    }

    public Rectangle convertViewToScene(Rectangle rectangle) {
        Point point = new Point(rectangle.x, rectangle.y);
        point = this.convertViewToScene(point);
        if (rectangle.isEmpty()) {
            return new Rectangle(point.x, point.y, 0, 0);
        }
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        point2 = this.convertViewToScene(point2);
        Rectangle rectangle2 = new Rectangle(point);
        rectangle2.add(point2);
        return rectangle2;
    }

    public Point convertViewToScene(Point point) {
        return new Point((int)((double)point.x / this.zoomFactor) - this.getLocation().x, (int)((double)point.y / this.zoomFactor) - this.getLocation().y);
    }

    public WidgetAction createWidgetHoverAction() {
        if (this.widgetHoverAction == null) {
            this.widgetHoverAction = ActionFactory.createHoverAction(new WidgetHoverAction());
            this.getActions().addAction(this.widgetHoverAction);
        }
        return this.widgetHoverAction;
    }

    @Override
    public void setResourceTable(ResourceTable resourceTable) {
        this.resourceTable = resourceTable;
    }

    @Override
    public ResourceTable getResourceTable() {
        return this.resourceTable;
    }

    public static interface SceneListener {
        public void sceneRepaint();

        public void sceneValidating();

        public void sceneValidated();
    }

    private class WidgetHoverAction
    implements TwoStateHoverProvider {
        private WidgetHoverAction() {
        }

        @Override
        public void unsetHovering(Widget widget) {
            widget.setState(widget.getState().deriveWidgetHovered(false));
        }

        @Override
        public void setHovering(Widget widget) {
            widget.setState(widget.getState().deriveWidgetHovered(true));
        }
    }
}

