/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.impl;

import java.lang.reflect.Field;
import java.util.Arrays;

public abstract class Root {
    private Root() {
    }

    public abstract String describe();

    public abstract Object getObject();

    public static Root createNamed(String string, Object object) {
        return new Named(string, object);
    }

    public static Root createStatic(Field field, Object object) {
        return new Static(field, object);
    }

    private static class Static
    extends Root {
        private Class cls;
        private int i;

        Static(Field field, Object object) {
            assert ((field.getModifiers() & 8) != 0);
            this.cls = field.getDeclaringClass();
            this.i = Arrays.asList(this.cls.getDeclaredFields()).indexOf(field);
            assert (this.i >= 0);
            assert (this.cls.getDeclaredFields()[this.i].equals(field));
        }

        @Override
        public String describe() {
            return this.getField().toString();
        }

        @Override
        public Object getObject() {
            try {
                return this.getField().get(null);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private Field getField() {
            return this.cls.getDeclaredFields()[this.i];
        }
    }

    private static class Named
    extends Root {
        private String name;
        private Object ref;

        Named(String string, Object object) {
            if (object == null) {
                new Exception().printStackTrace();
            }
            this.ref = object;
            this.name = string;
        }

        @Override
        public Object getObject() {
            return this.ref;
        }

        @Override
        public String describe() {
            return this.name;
        }
    }
}

