/*****************************************************************************
 * Copyright (C) 2000 Jim Kent.  This source code may be freely used         *
 * for personal, academic, and non-profit purposes.  Commercial use          *
 * permitted only by explicit agreement with Jim Kent (jim_kent@pacbell.net) *
 *****************************************************************************/
/* ggDbRep.h was originally generated by the autoSql program, which also 
 * generated ggDbRep.c and ggDbRep.sql.  This header links the database and the RAM 
 * representation of objects. */

struct altGraph
/* An alternatively spliced gene graph. */
    {
    struct altGraph *next;  /* Next in singly linked list. */
    unsigned id;	/* Unique ID */
    signed char orientation;	/* +1 or -1 relative to start bac */
    unsigned startBac;	/* First bac touched by graph */
    unsigned startPos;	/* Start position in first bac */
    unsigned endBac;	/* Last bac touched by graph */
    unsigned endPos;	/* End position in last bac */
    unsigned vertexCount;	/* Number of vertices in graph */
    unsigned char *vTypes;	/* Type for each vertex */
    unsigned *vBacs;	/* Bac for each vertex */
    unsigned *vPositions;	/* Position in bac for each vertex */
    unsigned edgeCount;	/* Number of edges in graph */
    unsigned *edgeStarts;	/* Array with start vertex of edges */
    unsigned *edgeEnds;	/* Array with end vertex of edges */
    int mrnaRefCount;	/* Number of supporting mRNAs */
    unsigned *mrnaRefs;	/* IDs of all supporting mRNAs */
    };

struct altGraph *altGraphLoad(char **row);
/* Load a altGraph from row fetched with select * from altGraph
 * from database.  Dispose of this with altGraphFree(). */

struct altGraph *altGraphCommaIn(char **pS);
/* Create a altGraph out of a comma separated string. */

void altGraphFree(struct altGraph **pEl);
/* Free a single dynamically allocated altGraph such as created
 * with altGraphLoad(). */

void altGraphFreeList(struct altGraph **pList);
/* Free a list of dynamically allocated altGraph's */

void altGraphOutput(struct altGraph *el, FILE *f, char sep, char lastSep);
/* Print out altGraph.  Separate fields with sep. Follow last field with lastSep. */

#define altGraphTabOut(el,f) altGraphOutput(el,f,'\t','\n');
/* Print out altGraph as a line in a tab-separated file. */

#define altGraphCommaOut(el,f) altGraphOutput(el,f,',',',');
/* Print out altGraph as a comma separated list including final comma. */

