# orthoAlleles.sql was originally generated by the autoSql program, which also 
# generated orthoAlleles.c and orthoAlleles.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#SNP data with orthologous alleles
CREATE TABLE orthoAlleles (
    bin smallint unsigned not null,          # To speed up searches
    chrom varchar(255) not null,             # Reference sequence chromosome or scaffold
    chromStart int unsigned not null,        # Start position in chrom
    chromEnd int unsigned not null,          # End position in chrom
    name varchar(255) not null,              # Name of SNP - rsId or temporary name
    score int unsigned not null,             # 0
    strand char(1) not null,                 # + or -
    allele1 char(1) not null,                # A, C, G, or T
    allele1Freq float not null,              # From 0.0 to 1.0
    allele1Count int unsigned not null,      # From 1 to sample size
    allele2 char(1) not null,                # A, C, G, or T, different from allele1
    allele2Freq float not null,              # 1.0 - allele1Freq
    allele2Count int unsigned not null,      # sample size - allele1Count
    ortho1Chrom varchar(255) not null,       # Chromosome of orthologous species 1
    ortho1ChromStart int unsigned not null,  # Start position in species 1
    ortho1ChromEnd int unsigned not null,    # End position in species 1
    ortho1Strand char(1) not null,           # + or - or .
    ortho1State varchar(255) not null,       # A, C, G, T, a, c, g, t, or .
    ortho2Chrom varchar(255) not null,       # Chromosome of orthologous species 2
    ortho2ChromStart int unsigned not null,  # Start position in species 2
    ortho2ChromEnd int unsigned not null,    # End position in species 2
    ortho2Strand char(1) not null,           # + or - or .
    ortho2State varchar(255) not null        # A, C, G, T, a, c, g, t, or .
);
