/* rgi.c was originally generated by the autoSql program, which also 
 * generated rgi.h and rgi.sql.  This module links the database and the RAM 
 * representation of objects. */

#include "common.h"
#include "jksql.h"
#include "rgi.h"


void rgiStaticLoad(char **row, struct rgi *ret)
/* Load a row from rgi table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
int sizeOne,i;
char *s;

ret->a = row[0];
ret->b = row[1];
ret->minDistance = sqlSigned(row[2]);
ret->maxDistance = sqlSigned(row[3]);
}

struct rgi *rgiLoad(char **row)
/* Load a rgi from row fetched with select * from rgi
 * from database.  Dispose of this with rgiFree(). */
{
struct rgi *ret;
int sizeOne,i;
char *s;

AllocVar(ret);
ret->a = cloneString(row[0]);
ret->b = cloneString(row[1]);
ret->minDistance = sqlSigned(row[2]);
ret->maxDistance = sqlSigned(row[3]);
return ret;
}

struct rgi *rgiCommaIn(char **pS, struct rgi *ret)
/* Create a rgi out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new rgi */
{
char *s = *pS;
int i;

if (ret == NULL)
    AllocVar(ret);
ret->a = sqlStringComma(&s);
ret->b = sqlStringComma(&s);
ret->minDistance = sqlSignedComma(&s);
ret->maxDistance = sqlSignedComma(&s);
*pS = s;
return ret;
}

void rgiFree(struct rgi **pEl)
/* Free a single dynamically allocated rgi such as created
 * with rgiLoad(). */
{
struct rgi *el;

if ((el = *pEl) == NULL) return;
freeMem(el->a);
freeMem(el->b);
freez(pEl);
}

void rgiFreeList(struct rgi **pList)
/* Free a list of dynamically allocated rgi's */
{
struct rgi *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    rgiFree(&el);
    }
*pList = NULL;
}

void rgiOutput(struct rgi *el, FILE *f, char sep, char lastSep) 
/* Print out rgi.  Separate fields with sep. Follow last field with lastSep. */
{
int i;
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->a, sep);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->b, sep);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->minDistance, sep);
fputc(sep,f);
fprintf(f, "%d", el->maxDistance, lastSep);
fputc(lastSep,f);
}

