/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.net.URI;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.MergeUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public final class MergeTopicParser
extends XMLFilterImpl {
    private File dirPath = null;
    private String filePath = null;
    private String rootLang = null;
    private String firstTopicId = null;
    private final MergeUtils util;
    private Job job;
    private DITAOTLogger logger;
    private File output;
    private final String GENERATED_DITA_ELEMENT_ID = "GENERATED-DITA-ID";

    public MergeTopicParser(MergeUtils util) {
        this.util = util;
    }

    public final void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    public final void setJob(Job job) {
        this.job = job;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public String getFirstTopicId() {
        return this.firstTopicId;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.getContentHandler().endElement(uri, localName, qName);
    }

    private void handleID(AttributesImpl atts) {
        String idValue = atts.getValue("id");
        if (idValue != null) {
            XMLUtils.addOrSetAttribute(atts, "oid", idValue);
            URI value = URLUtils.setFragment(URLUtils.toDirURI(this.dirPath).resolve(URLUtils.toURI(this.filePath)), idValue);
            idValue = this.util.findId(value) ? this.util.getIdValue(value) : this.util.addId(value);
            XMLUtils.addOrSetAttribute(atts, "id", idValue);
        }
    }

    private URI handleLocalDita(URI href, AttributesImpl atts) {
        URI retAttValue;
        URI attValue = href;
        int sharpIndex = attValue.toString().indexOf("#");
        if (sharpIndex != -1) {
            URI pathFromMap = sharpIndex == 0 ? URLUtils.toURI(this.filePath) : URLUtils.toURI(this.filePath).resolve(attValue.toString().substring(0, sharpIndex));
            XMLUtils.addOrSetAttribute(atts, "ohref", URLUtils.toURI(String.valueOf(pathFromMap) + attValue.toString().substring(sharpIndex)).toString());
            String topicID = this.getTopicID(attValue.getFragment());
            int index = attValue.toString().indexOf("/", sharpIndex);
            String elementId = index != -1 ? attValue.toString().substring(index) : "";
            URI pathWithTopicID = URLUtils.setFragment(URLUtils.toDirURI(this.dirPath).resolve(pathFromMap), topicID);
            retAttValue = this.util.findId(pathWithTopicID) ? URLUtils.toURI("#" + this.util.getIdValue(pathWithTopicID) + elementId) : URLUtils.toURI("#" + this.util.addId(pathWithTopicID) + elementId);
        } else {
            URI pathFromMap = URLUtils.toURI(this.filePath).resolve(attValue.toString());
            URI absolutePath = URLUtils.toDirURI(this.dirPath).resolve(pathFromMap);
            XMLUtils.addOrSetAttribute(atts, "ohref", pathFromMap.toString());
            if (this.util.findId(absolutePath)) {
                retAttValue = URLUtils.toURI("#" + this.util.getIdValue(absolutePath));
            } else {
                String fileId = this.util.getFirstTopicId(absolutePath, false);
                URI key = URLUtils.setFragment(absolutePath, fileId);
                if (this.util.findId(key)) {
                    this.util.addId(absolutePath, this.util.getIdValue(key));
                    retAttValue = URLUtils.toURI("#" + this.util.getIdValue(key));
                } else {
                    retAttValue = URLUtils.toURI("#" + this.util.addId(absolutePath));
                    this.util.addId(key, this.util.getIdValue(absolutePath));
                }
            }
        }
        return retAttValue;
    }

    private String getTopicID(String fragment) {
        int slashIndex = fragment.indexOf("/");
        return slashIndex != -1 ? fragment.substring(0, slashIndex) : fragment;
    }

    public void parse(String filename, File dir) {
        this.filePath = FileUtils.stripFragment(filename);
        this.dirPath = dir;
        try {
            URI f = dir.toPath().resolve(this.filePath).toAbsolutePath().toFile().toURI();
            this.logger.info("Processing " + String.valueOf(f));
            this.job.getStore().transform(f, this);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse " + filename + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.firstTopicId = null;
        this.rootLang = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        AttributesImpl atts = new AttributesImpl(attributes);
        String classValue = atts.getValue("class");
        if ("dita".equals(qName)) {
            this.rootLang = attributes.getValue("http://www.w3.org/XML/1998/namespace", "lang");
            if (atts.getValue("id") == null) {
                XMLUtils.addOrSetAttribute(atts, "id", "GENERATED-DITA-ID");
            }
        }
        if (Constants.TOPIC_TOPIC.matches(classValue) || "dita".equals(qName)) {
            this.handleID(atts);
            if (this.firstTopicId == null) {
                this.firstTopicId = atts.getValue("id");
            }
        }
        this.handleHref(classValue, atts);
        this.getContentHandler().startElement(uri, localName, qName, atts);
    }

    private void handleHref(String classValue, AttributesImpl atts) {
        String scopeValue;
        URI attValue = URLUtils.toURI(atts.getValue("href"));
        if (attValue != null && DitaUtils.isLocalScope(scopeValue = atts.getValue("scope")) && attValue.getScheme() == null) {
            String formatValue = atts.getValue("format");
            if ((Constants.TOPIC_XREF.matches(classValue) || Constants.TOPIC_LINK.matches(classValue) || Constants.TOPIC_LQ.matches(classValue) || Constants.TOPIC_TERM.matches(classValue) || Constants.TOPIC_KEYWORD.matches(classValue) || Constants.TOPIC_CITE.matches(classValue) || Constants.TOPIC_PH.matches(classValue) || Constants.TOPIC_DT.matches(classValue)) && (formatValue == null || "dita".equals(formatValue))) {
                XMLUtils.addOrSetAttribute(atts, "href", this.handleLocalDita(attValue, atts).toString());
            } else {
                XMLUtils.addOrSetAttribute(atts, "href", this.handleLocalHref(attValue).toString());
            }
        }
    }

    private URI handleLocalHref(URI attValue) {
        URI current = this.dirPath.toPath().resolve(this.filePath).toUri().normalize();
        URI reference = current.resolve(attValue);
        URI merge = this.output.toURI();
        return URLUtils.getRelativePath(merge, reference);
    }
}

