/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.IOException;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.reader.AbstractReader;
import org.dita.dost.util.Job;
import org.w3c.dom.Document;

public abstract class AbstractDomFilter
implements AbstractReader {
    protected DITAOTLogger logger;
    protected Job job;

    @Override
    public void read(File filename) throws DITAOTException {
        Document doc;
        assert (filename.isAbsolute());
        this.logger.info("Processing " + String.valueOf(filename.toURI()));
        try {
            doc = this.job.getStore().getDocument(filename.toURI());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DITAOTException("Failed to parse " + filename.getAbsolutePath() + ":" + e.getMessage(), e);
        }
        Document resDoc = this.process(doc);
        if (resDoc != null) {
            try {
                this.logger.debug("Writing " + String.valueOf(filename.toURI()));
                resDoc.setDocumentURI(filename.toURI().toString());
                this.job.getStore().writeDocument(resDoc, filename.toURI());
            }
            catch (IOException e) {
                throw new DITAOTException("Failed to serialize " + filename.getAbsolutePath() + ": " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    @Override
    public void setJob(Job job) {
        this.job = job;
    }

    protected abstract Document process(Document var1);
}

