/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjaropenbeans;

import groovyjarjarharmonybeans.BeansUtils;
import groovyjarjaropenbeans.BeanInfo;
import groovyjarjaropenbeans.Encoder;
import groovyjarjaropenbeans.Expression;
import groovyjarjaropenbeans.IntrospectionException;
import groovyjarjaropenbeans.Introspector;
import groovyjarjaropenbeans.PersistenceDelegate;
import groovyjarjaropenbeans.PropertyDescriptor;
import groovyjarjaropenbeans.Statement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;

public class DefaultPersistenceDelegate
extends PersistenceDelegate {
    private static String[] EMPTY_PROPERTIES = new String[0];
    private String[] propertyNames = EMPTY_PROPERTIES;

    public DefaultPersistenceDelegate() {
    }

    public DefaultPersistenceDelegate(String[] propertyNames) {
        if (propertyNames != null) {
            this.propertyNames = propertyNames;
        }
    }

    @Override
    protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder enc) {
        super.initialize(type, oldInstance, newInstance, enc);
        if (type != oldInstance.getClass()) {
            return;
        }
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(type);
        }
        catch (IntrospectionException ex) {
            enc.getExceptionListener().exceptionThrown(ex);
            return;
        }
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        int i = 0;
        while (i < pds.length) {
            if (!Boolean.TRUE.equals(pds[i].getValue("transient"))) {
                Method getter = pds[i].getReadMethod();
                Method setter = pds[i].getWriteMethod();
                if (getter != null && setter != null) {
                    Expression getterExp = new Expression(oldInstance, getter.getName(), null);
                    try {
                        Object oldVal = getterExp.getValue();
                        enc.writeExpression(getterExp);
                        Object targetVal = enc.get(oldVal);
                        Object newVal = new Expression(newInstance, getter.getName(), null).getValue();
                        if (targetVal == null ? newVal != null && oldVal == null : targetVal != newVal && !targetVal.equals(newVal)) {
                            enc.writeStatement(new Statement(oldInstance, setter.getName(), new Object[]{oldVal}));
                        }
                    }
                    catch (Exception ex) {
                        enc.getExceptionListener().exceptionThrown(ex);
                    }
                }
            }
            ++i;
        }
    }

    private Object getFieldValue(Object oldInstance, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Class<?> c = oldInstance.getClass();
        final Field f = c.getDeclaredField(fieldName);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                f.setAccessible(true);
                return null;
            }
        });
        return f.get(oldInstance);
    }

    private Object getPropertyValue(HashMap<String, PropertyDescriptor> proDscMap, Object oldInstance, String propName) throws Exception {
        PropertyDescriptor pd;
        Method getter = null;
        if (proDscMap != null && (pd = proDscMap.get(Introspector.decapitalize(propName))) != null) {
            getter = pd.getReadMethod();
        }
        if (getter != null) {
            return getter.invoke(oldInstance, null);
        }
        try {
            return this.getFieldValue(oldInstance, propName);
        }
        catch (Exception ex) {
            throw new NoSuchMethodException("The getter method for the property " + propName + " can't be found.");
        }
    }

    @Override
    protected Expression instantiate(Object oldInstance, Encoder enc) {
        Object[] args = null;
        if (this.propertyNames.length > 0) {
            BeanInfo info = null;
            HashMap<String, PropertyDescriptor> proDscMap = null;
            try {
                info = Introspector.getBeanInfo(oldInstance.getClass(), 3);
                proDscMap = DefaultPersistenceDelegate.internalAsMap(info.getPropertyDescriptors());
            }
            catch (IntrospectionException ex) {
                enc.getExceptionListener().exceptionThrown(ex);
                throw new Error(ex);
            }
            args = new Object[this.propertyNames.length];
            int i = 0;
            while (i < this.propertyNames.length) {
                String propertyName = this.propertyNames[i];
                if (propertyName != null && propertyName.length() != 0) {
                    try {
                        args[i] = this.getPropertyValue(proDscMap, oldInstance, this.propertyNames[i]);
                    }
                    catch (Exception ex) {
                        enc.getExceptionListener().exceptionThrown(ex);
                    }
                }
                ++i;
            }
        }
        return new Expression(oldInstance, oldInstance.getClass(), "new", args);
    }

    private static HashMap<String, PropertyDescriptor> internalAsMap(PropertyDescriptor[] propertyDescs) {
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        int i = 0;
        while (i < propertyDescs.length) {
            map.put(propertyDescs[i].getName(), propertyDescs[i]);
            ++i;
        }
        return map;
    }

    @Override
    protected boolean mutatesTo(Object o1, Object o2) {
        if (this.propertyNames.length > 0 && BeansUtils.declaredEquals(o1.getClass())) {
            return o1.equals(o2);
        }
        return super.mutatesTo(o1, o2);
    }
}

