/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.util.ArrayList;
import java.util.List;
import org.xmind.core.licensing.ILicenseAgent;
import org.xmind.core.licensing.ILicenseChangedListener;
import org.xmind.core.licensing.ILicenseKeyHeader;

public class LicenseAgentProxy
implements ILicenseAgent {
    private ILicenseAgent delegate = null;
    private final List<ILicenseChangedListener> listeners = new ArrayList<ILicenseChangedListener>(1);

    public void setDelegate(ILicenseAgent delegate) {
        ILicenseAgent oldDelegate = this.delegate;
        if (delegate == oldDelegate) {
            return;
        }
        if (oldDelegate != null) {
            for (ILicenseChangedListener listener : this.listeners) {
                oldDelegate.removeLicenseChangedListener(listener);
            }
        }
        this.delegate = delegate;
        if (delegate != null) {
            for (ILicenseChangedListener listener : this.listeners) {
                delegate.addLicenseChangedListener(listener);
            }
        }
        for (ILicenseChangedListener listener : this.listeners) {
            listener.licenseChanged((ILicenseAgent)this);
        }
    }

    public int getLicenseType() {
        return this.delegate == null ? 1 : this.delegate.getLicenseType();
    }

    public String getLicenseeName() {
        return this.delegate == null ? null : this.delegate.getLicenseeName();
    }

    public ILicenseKeyHeader getLicenseKeyHeader() {
        return this.delegate == null ? null : this.delegate.getLicenseKeyHeader();
    }

    public void addLicenseChangedListener(ILicenseChangedListener listener) {
        this.listeners.add(listener);
        if (this.delegate != null) {
            this.delegate.addLicenseChangedListener(listener);
        }
    }

    public void removeLicenseChangedListener(ILicenseChangedListener listener) {
        this.listeners.remove(listener);
        if (this.delegate != null) {
            this.delegate.removeLicenseChangedListener(listener);
        }
    }
}

