/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.util.UITimer;
import org.xmind.ui.viewers.ImageButton;

public class SmoothPopupDialog
extends Window {
    private static Map<String, PopupGroup> groups = new HashMap<String, PopupGroup>();
    protected static final String DEFAULT_BACKGROUDCOLOR_VALUE = "#e9e8e9";
    private static final int VERTICAL_SPEED = 3;
    private static final int ANIM_INTERVALS = 8;
    private static final GridDataFactory LAYOUTDATA_GRAB_BOTH = GridDataFactory.fillDefaults().grab(true, true);
    private static final GridDataFactory LAYOUTDATA_GRAB_HORIZONTAL = GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false);
    private static final GridDataFactory LAYOUTDATA_ALIGN_RIGHT = GridDataFactory.fillDefaults().align(0x1000008, 0x1000000);
    private static final GridLayoutFactory LAYOUT_CONTENTS = GridLayoutFactory.fillDefaults().numColumns(1).margins(1, 1).extendedMargins(0, 0, 0, 0).spacing(1, 1);
    public static final int POPUP_MARGINWIDTH = 0;
    public static final int POPUP_MARGINHEIGHT = 0;
    public static final int POPUP_VERTICALSPACING = 1;
    public static final int POPUP_HORIZONTALSPACING = 1;
    private static final GridLayoutFactory POPUP_LAYOUT_FACTORY = GridLayoutFactory.fillDefaults().margins(0, 0).spacing(1, 1);
    private static final int POPUP_GAP = 3;
    private static final int BORDER_THICKNESS = 1;
    private static int STAY_DURATION = 5000;
    protected static ImageDescriptor IMG_CLOSE_NORMAL = null;
    private Point DEFAULT_TARGET_SIZE;
    private boolean showCloseButton = false;
    private Point targetSize = null;
    private String titleText = null;
    private Control dialogArea = null;
    private Point startingBottomRight = null;
    private boolean centerPopUp = false;
    private boolean popup = false;
    private UITimer timer = null;
    private int targetWidth = 0;
    private int targetHeight = 0;
    private int currentHeight = 0;
    private PullDownTask pullDownTask = null;
    private Control sourceControl = null;
    private Listener sourceControlMoveListener = null;
    private PopupGroup group = null;
    private int duration = STAY_DURATION;

    public SmoothPopupDialog(Shell parent, boolean showCloseButton, String titleText) {
        super(parent);
        this.setShellStyle(4);
        this.setBlockOnOpen(false);
        this.showCloseButton = showCloseButton;
        this.titleText = titleText;
        Point size = parent.getSize();
        this.DEFAULT_TARGET_SIZE = new Point(size.x * 70 / 100, -1);
    }

    public void setDuration(int stayDuration) {
        this.duration = stayDuration;
    }

    public int getDuration() {
        return this.duration;
    }

    protected void configureShell(Shell shell) {
        Display display = shell.getDisplay();
        int border = this.getBorderThickness();
        shell.setLayout((Layout)new BorderFillLayout(border));
        if (border > 0) {
            Color borderColor = this.getBorderColor(display);
            if (borderColor == null) {
                borderColor = display.getSystemColor(15);
            }
            shell.setBackground(borderColor);
        }
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                SmoothPopupDialog.this.handleDispose();
            }
        });
    }

    private int getBorderThickness() {
        return (this.getShellStyle() & 8) == 0 ? 0 : 1;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        LAYOUT_CONTENTS.applyTo(composite);
        if (this.hasTitleArea()) {
            Control titleArea = this.createTitleArea(composite);
            LAYOUTDATA_GRAB_HORIZONTAL.applyTo(titleArea);
        }
        this.dialogArea = this.createDialogArea(composite);
        if (this.dialogArea.getLayoutData() == null) {
            LAYOUTDATA_GRAB_BOTH.applyTo(this.dialogArea);
        }
        this.applyColors(composite);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        POPUP_LAYOUT_FACTORY.applyTo(composite);
        return composite;
    }

    protected boolean hasTitleArea() {
        return this.titleText != null || this.showCloseButton;
    }

    protected Control createTitleArea(Composite parent) {
        Composite titleAreaComposite = new Composite(parent, 0);
        boolean hasTitle = this.titleText != null;
        GridLayoutFactory.fillDefaults().numColumns(hasTitle && this.showCloseButton ? 2 : 1).applyTo(titleAreaComposite);
        if (hasTitle) {
            Control title = this.createTitleControl(titleAreaComposite);
            LAYOUTDATA_GRAB_HORIZONTAL.applyTo(title);
        }
        if (this.showCloseButton) {
            Control closeButton = this.createCloseButton(titleAreaComposite);
            LAYOUTDATA_ALIGN_RIGHT.grab(!hasTitle, false).applyTo(closeButton);
        }
        return titleAreaComposite;
    }

    protected Control createCloseButton(Composite parent) {
        ImageButton closeButton = new ImageButton(parent, 0);
        closeButton.setNormalImageDescriptor(this.getCloseButtonNormalImage());
        closeButton.setDisabledImageDescriptor(this.getDisabledCloseButtonImage());
        closeButton.setHoveredImageDescriptor(this.getHoverCloseButtonImage());
        closeButton.setPressedImageDescriptor(this.getPressedCloseButtonImage());
        closeButton.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                SmoothPopupDialog.this.close();
            }
        });
        return closeButton.getControl();
    }

    public static void setDefaultCloseButtonNormalImage(ImageDescriptor img) {
        IMG_CLOSE_NORMAL = img;
    }

    protected ImageDescriptor getCloseButtonNormalImage() {
        if (IMG_CLOSE_NORMAL == null) {
            IMG_CLOSE_NORMAL = SmoothPopupDialog.createDefaultCloseButtonImage();
        }
        return IMG_CLOSE_NORMAL;
    }

    private static ImageDescriptor createDefaultCloseButtonImage() {
        Display display = Display.getCurrent();
        Image img = new Image((Device)display, 16, 16);
        GC gc = new GC((Drawable)img);
        gc.setForeground(display.getSystemColor(15));
        gc.setBackground(ColorUtils.getColor(DEFAULT_BACKGROUDCOLOR_VALUE));
        gc.fillRectangle(0, 0, 16, 16);
        gc.setLineWidth(2);
        gc.drawLine(4, 4, 11, 11);
        gc.drawLine(4, 11, 11, 4);
        gc.dispose();
        ImageData data = img.getImageData();
        img.dispose();
        return ImageDescriptor.createFromImageData((ImageData)data);
    }

    protected ImageDescriptor getHoverCloseButtonImage() {
        return null;
    }

    protected ImageDescriptor getDisabledCloseButtonImage() {
        return null;
    }

    protected ImageDescriptor getPressedCloseButtonImage() {
        return null;
    }

    protected Control createTitleControl(Composite parent) {
        Composite titleContainer = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(5, 2).spacing(0, 0).numColumns(1).applyTo(titleContainer);
        Label title = new Label(titleContainer, 0);
        if (this.titleText != null) {
            title.setText(this.titleText);
        }
        LAYOUTDATA_GRAB_HORIZONTAL.applyTo((Control)title);
        return titleContainer;
    }

    private void applyColors(Composite composite) {
        Display display = this.getShell().getDisplay();
        this.applyForegroundColor(display.getSystemColor(16), (Control)composite, this.getForegroundColorExclusions());
        this.applyBackgroundColor(ColorUtils.getColor(DEFAULT_BACKGROUDCOLOR_VALUE), (Control)composite, this.getBackgroundColorExclusions());
    }

    private void applyForegroundColor(Color color, Control control, List exclusions) {
        if (exclusions.contains(control)) {
            return;
        }
        control.setForeground(color);
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                this.applyForegroundColor(color, children[i], exclusions);
                ++i;
            }
        }
    }

    private void applyBackgroundColor(Color color, Control control, List exclusions) {
        if (exclusions.contains(control)) {
            return;
        }
        control.setBackground(color);
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                this.applyBackgroundColor(color, children[i], exclusions);
                ++i;
            }
        }
    }

    protected void applyForegroundColor(Color color, Control control) {
        this.applyForegroundColor(color, control, this.getForegroundColorExclusions());
    }

    protected void applyBackgroundColor(Color color, Control control) {
        this.applyBackgroundColor(color, control, this.getBackgroundColorExclusions());
    }

    protected List getForegroundColorExclusions() {
        ArrayList list = new ArrayList(3);
        return list;
    }

    protected List getBackgroundColorExclusions() {
        ArrayList list = new ArrayList(2);
        return list;
    }

    protected Color getBorderColor(Display display) {
        return null;
    }

    protected Point getTargetSize() {
        return this.targetSize;
    }

    protected void setTargetSize(Point targetSize) {
        this.targetSize = targetSize;
    }

    protected void setCenterPopUp(boolean centerPopUp) {
        this.centerPopUp = centerPopUp;
    }

    public void setGroupId(String groupId) {
        if (groupId == null) {
            if (this.group != null) {
                this.group.remove(this);
                this.group = null;
            }
        } else {
            this.group = groups.get(groupId);
            if (this.group == null) {
                this.group = new PopupGroup();
                groups.put(groupId, this.group);
            }
        }
    }

    public void popUp() {
        IWorkbenchWindow window;
        Display display = Display.getCurrent();
        Shell shell = null;
        if (PlatformUI.isWorkbenchRunning() && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            shell = window.getShell();
        }
        if (shell == null) {
            shell = display.getActiveShell();
        }
        if (shell != null && !shell.isDisposed()) {
            this.popUp((Control)shell);
        } else {
            Rectangle area = display.getClientArea();
            this.popUp(area.x + area.width - 50, area.y + area.height - 50);
        }
    }

    public void popUp(Control sourceControl) {
        this.open(sourceControl, true);
    }

    public void popUp(int right, int bottom) {
        this.open(right, bottom, true);
    }

    public void open(Control sourceControl) {
        this.open(sourceControl, false);
    }

    public void open(int right, int bottom) {
        this.open(right, bottom, false);
    }

    protected void open(Control sourceControl, boolean popup) {
        if (this.sourceControlMoveListener != null) {
            sourceControl.removeListener(10, this.sourceControlMoveListener);
            if (this.sourceControl != null) {
                this.sourceControl.removeListener(10, this.sourceControlMoveListener);
            }
        }
        this.sourceControl = sourceControl;
        if (this.sourceControlMoveListener == null) {
            this.sourceControlMoveListener = new Listener(){

                public void handleEvent(Event event) {
                    SmoothPopupDialog.this.group = null;
                    SmoothPopupDialog.this.updateShellBounds(SmoothPopupDialog.this.currentHeight);
                }
            };
        }
        this.sourceControl.addListener(10, this.sourceControlMoveListener);
        Point bottomRight = this.getBottomRight(sourceControl);
        this.open(bottomRight.x, bottomRight.y, popup);
    }

    private Point getBottomRight(Control sourceControl) {
        Rectangle bounds = this.getSourceArea(sourceControl);
        Point loc = sourceControl.toDisplay(bounds.x, bounds.y);
        int pointX = loc.x + bounds.width - 3;
        if (this.centerPopUp) {
            pointX = pointX - bounds.width / 2 + 3;
            pointX = this.targetSize != null ? (pointX += this.targetSize.x / 2) : (pointX += this.DEFAULT_TARGET_SIZE.x / 2);
        }
        return new Point(pointX, loc.y + bounds.height - 3);
    }

    private Rectangle getSourceArea(Control sourceControl) {
        Rectangle bounds = sourceControl.getBounds();
        if (sourceControl instanceof Composite) {
            Rectangle computedSize = ((Composite)sourceControl).getClientArea();
            return computedSize;
        }
        return bounds;
    }

    protected void open(int right, int bottom, boolean popup) {
        this.startingBottomRight = this.getStartingBottomRight(right, bottom);
        this.popup = popup;
        this.open();
    }

    private Point getStartingBottomRight(int right, int bottom) {
        if (this.group != null) {
            Point bottomRight = this.group.getBottomRight();
            if (bottomRight == null) {
                this.group.setBottomRight(right, bottom);
                bottomRight = this.group.getBottomRight();
            }
            return new Point(bottomRight.x, bottomRight.y);
        }
        return new Point(right, bottom);
    }

    public int open() {
        this.stop();
        Shell shell = this.showShell();
        if (this.group != null) {
            this.group.add(this, this.targetHeight, this.targetWidth);
        }
        if (shell != null && !shell.isDisposed()) {
            if (this.popup && this.startingBottomRight != null) {
                this.doPopUp(shell);
            } else {
                this.postOpen();
            }
            this.popup = false;
        }
        return 0;
    }

    private Shell showShell() {
        Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            shell = null;
            this.create();
            shell = this.getShell();
        }
        this.initializeBounds();
        this.constrainShellSize();
        shell.setVisible(true);
        return shell;
    }

    private void doPopUp(Shell shell) {
        this.currentHeight = shell.getSize().y;
        this.timer = new UITimer(0, 8, (ISafeRunnable)new SafeRunnable(){

            public void run() {
                SmoothPopupDialog smoothPopupDialog = SmoothPopupDialog.this;
                smoothPopupDialog.currentHeight = smoothPopupDialog.currentHeight + 3;
                if (SmoothPopupDialog.this.currentHeight > SmoothPopupDialog.this.targetHeight) {
                    SmoothPopupDialog.this.stop();
                    SmoothPopupDialog.this.postOpen();
                } else {
                    SmoothPopupDialog.this.updateShellBounds(SmoothPopupDialog.this.currentHeight);
                }
            }
        });
        this.timer.run();
    }

    protected void postOpen() {
        this.updateShellBounds(this.targetHeight);
        if (this.getDuration() > 0) {
            Display display = this.getShell().getDisplay();
            this.pullDownTask = new PullDownTask(display);
            display.timerExec(this.getDuration(), (Runnable)this.pullDownTask);
        }
        this.currentHeight = this.targetHeight;
    }

    protected void updateShellBounds(int height) {
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setRedraw(false);
            shell.setBounds(this.getCurrentBounds(height, shell));
            shell.setRedraw(true);
        }
    }

    protected Rectangle getCurrentBounds(int height, Shell shell) {
        Point bottomRight;
        Point start = this.sourceControl != null && this.group == null ? this.getBottomRight(this.sourceControl) : this.startingBottomRight;
        if (start != null) {
            bottomRight = new Point(start.x, start.y);
        } else {
            Rectangle bounds = shell.getBounds();
            bottomRight = new Point(bounds.x + bounds.width, bounds.y + bounds.height);
        }
        int x = bottomRight.x - this.targetWidth;
        int y = bottomRight.y - height;
        return new Rectangle(x, y, this.targetWidth, height);
    }

    private void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.pullDownTask != null) {
            this.pullDownTask.cancel();
            this.pullDownTask = null;
        }
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        this.targetWidth = size.x;
        this.targetHeight = size.y;
        if (!this.popup) {
            return size;
        }
        return new Point(size.x, 1);
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.startingBottomRight == null) {
            return super.getInitialLocation(initialSize);
        }
        return new Point(this.startingBottomRight.x - initialSize.x, this.startingBottomRight.y - initialSize.y);
    }

    public static int getStayDuration() {
        return STAY_DURATION;
    }

    public static void setStayDuration(int duration) {
        STAY_DURATION = duration;
    }

    public boolean isShowing() {
        return this.getShell() != null && !this.getShell().isDisposed();
    }

    public boolean close() {
        this.stop();
        this.currentHeight = 0;
        if (this.group != null) {
            this.group.remove(this);
        }
        return super.close();
    }

    public void pullDown() {
        this.stop();
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            this.targetHeight = 0;
            this.doPullDown(shell);
        }
    }

    private void doPullDown(Shell shell) {
        Rectangle bounds = shell.getBounds();
        this.currentHeight = bounds.height;
        this.timer = new UITimer(0, 8, (ISafeRunnable)new SafeRunnable(){

            public void run() {
                SmoothPopupDialog smoothPopupDialog = SmoothPopupDialog.this;
                smoothPopupDialog.currentHeight = smoothPopupDialog.currentHeight - 3;
                if (SmoothPopupDialog.this.currentHeight <= 0) {
                    SmoothPopupDialog.this.close();
                } else {
                    SmoothPopupDialog.this.updateShellBounds(SmoothPopupDialog.this.currentHeight);
                }
            }
        });
        this.timer.run();
    }

    protected void handleDispose() {
        this.stop();
        if (this.sourceControl != null && !this.sourceControl.isDisposed()) {
            if (this.sourceControlMoveListener != null) {
                this.sourceControl.removeListener(10, this.sourceControlMoveListener);
            }
            this.sourceControl = null;
        }
    }

    private final class BorderFillLayout
    extends Layout {
        private int borderWidth;
        private int margin;

        public BorderFillLayout(int borderWidth) {
            this.borderWidth = borderWidth;
            this.margin = borderWidth + borderWidth;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point size = this.computeContentSize();
            return new Point(size.x + this.margin, size.y + this.margin);
        }

        private Point computeContentSize() {
            if (SmoothPopupDialog.this.targetSize != null) {
                return SmoothPopupDialog.this.targetSize;
            }
            if (SmoothPopupDialog.this.getContents() != null) {
                return SmoothPopupDialog.this.getContents().computeSize(((SmoothPopupDialog)SmoothPopupDialog.this).DEFAULT_TARGET_SIZE.x, ((SmoothPopupDialog)SmoothPopupDialog.this).DEFAULT_TARGET_SIZE.y);
            }
            return SmoothPopupDialog.this.DEFAULT_TARGET_SIZE;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Control[] children;
            int x = this.borderWidth;
            int y = this.borderWidth;
            Rectangle clientArea = composite.getClientArea();
            if (SmoothPopupDialog.this.targetSize != null) {
                clientArea.width = ((SmoothPopupDialog)SmoothPopupDialog.this).targetSize.x;
                clientArea.height = ((SmoothPopupDialog)SmoothPopupDialog.this).targetSize.y;
            }
            int width = clientArea.width;
            int height = clientArea.height;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.setBounds(x, y, width - 2 * this.borderWidth, height - 2 * this.borderWidth);
                ++n2;
            }
        }
    }

    private static class PopupGroup {
        private Point initBottomRight = null;
        private Point bottomRight = null;
        private int width = 0;
        private List<SmoothPopupDialog> dialogs = new ArrayList<SmoothPopupDialog>();

        private PopupGroup() {
        }

        public Point getBottomRight() {
            return this.bottomRight;
        }

        public void setBottomRight(int right, int bottom) {
            this.initBottomRight = new Point(right, bottom);
            this.bottomRight = new Point(right, bottom);
        }

        public void add(SmoothPopupDialog dialog, int height, int width) {
            if (this.bottomRight == null) {
                throw new IllegalStateException();
            }
            this.dialogs.add(dialog);
            int top = this.bottomRight.y - height;
            if (top < Display.getCurrent().getClientArea().y) {
                this.bottomRight.x -= this.width;
                this.bottomRight.y = this.initBottomRight.y;
            } else {
                this.width = Math.max(this.width, width);
                this.bottomRight.y -= height;
            }
        }

        public void remove(SmoothPopupDialog dialog) {
            this.dialogs.remove((Object)dialog);
            if (this.dialogs.isEmpty()) {
                this.initBottomRight = null;
                this.bottomRight = null;
            }
        }
    }

    protected class PullDownTask
    implements Runnable {
        Display display;
        boolean canceled = false;

        public PullDownTask(Display display) {
            this.display = display;
        }

        public void cancel() {
            this.canceled = true;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        @Override
        public void run() {
            if (this.canceled || this.display.isDisposed()) {
                return;
            }
            SmoothPopupDialog.this.pullDown();
        }
    }
}

